package org.example;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

import java.io.IOException;

public class TransactionInfoDeserializer implements Deserializer<TransactionInfo> {
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public TransactionInfo deserialize(String topic, byte[] data) {
        try {
            return objectMapper.readValue(data, TransactionInfo.class);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}