/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ssl.SslBundleRegistrar;
import org.springframework.boot.autoconfigure.ssl.SslProperties;
import org.springframework.boot.autoconfigure.ssl.SslPropertiesBundleRegistrar;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.DefaultSslBundleRegistry;
import org.springframework.boot.ssl.SslBundleRegistry;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={SslProperties.class})
public class SslAutoConfiguration {
    SslAutoConfiguration() {
    }

    @Bean
    public SslPropertiesBundleRegistrar sslPropertiesSslBundleRegistrar(SslProperties sslProperties) {
        return new SslPropertiesBundleRegistrar(sslProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={SslBundleRegistry.class, SslBundles.class})
    public DefaultSslBundleRegistry sslBundleRegistry(List<SslBundleRegistrar> sslBundleRegistrars) {
        DefaultSslBundleRegistry registry = new DefaultSslBundleRegistry();
        sslBundleRegistrars.forEach(registrar -> registrar.registerBundles(registry));
        return registry;
    }
}

