/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.TransactionInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyProducer {
    private static final String TOPIC = "";
    private static final String BOOTSTRAP_SERVERS = "localhost:9092";
    private static final Logger log = LoggerFactory.getLogger(MyProducer.class);

    public static boolean logTransaction(TransactionInfo transactionInfo, String topic) {
        log.info("Registering A Transaction for Mr/Ms : " + transactionInfo.getName());
        ObjectMapper objectMapper = new ObjectMapper();
        String value = null;
        try {
            value = objectMapper.writeValueAsString(transactionInfo);
        }
        catch (JsonProcessingException e) {
            log.error("Transaction for Mr/Ms : " + transactionInfo.getName() + " Could Not Be Processed To Json");
            return false;
        }
        Producer<Long, String> kafkaProducer = MyProducer.createKafkaProducer(BOOTSTRAP_SERVERS);
        long timeStamp = System.currentTimeMillis();
        ProducerRecord<Long, String> record = new ProducerRecord<Long, String>(topic, timeStamp, value);
        RecordMetadata recordMetadata = null;
        try {
            recordMetadata = kafkaProducer.send(record).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Could Not Send Data to Kafka , Or Could Not Get Meta-Data");
            return false;
        }
        log.info(String.format("Record for Mr/Ms : %s -  with (key: %s, value: %s), was sent to (partition: %d, offset: %d)", transactionInfo.getName(), record.key(), record.value(), recordMetadata.partition(), recordMetadata.offset()));
        System.out.println(String.format("Record for Mr/Ms : %s -  with (key: %s, value: %s), was sent to (partition: %d, offset: %d)", transactionInfo.getName(), record.key(), record.value(), recordMetadata.partition(), recordMetadata.offset()));
        kafkaProducer.flush();
        kafkaProducer.close();
        return true;
    }

    public static Producer<Long, String> createKafkaProducer(String bootstrapServers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("client.id", "events-producer");
        properties.put("key.serializer", LongSerializer.class.getName());
        properties.put("value.serializer", StringSerializer.class.getName());
        return new KafkaProducer<Long, String>(properties);
    }
}

