/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.AotDetector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.ApplicationEnvironment;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.Banner;
import org.springframework.boot.BeanDefinitionLoader;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.boot.DefaultBootstrapContext;
import org.springframework.boot.DefaultPropertiesPropertySource;
import org.springframework.boot.EnvironmentConverter;
import org.springframework.boot.ExitCodeEvent;
import org.springframework.boot.ExitCodeExceptionMapper;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.ExitCodeGenerators;
import org.springframework.boot.LazyInitializationBeanFactoryPostProcessor;
import org.springframework.boot.Runner;
import org.springframework.boot.SpringApplicationBannerPrinter;
import org.springframework.boot.SpringApplicationHook;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.SpringApplicationRunListeners;
import org.springframework.boot.SpringApplicationShutdownHandlers;
import org.springframework.boot.SpringApplicationShutdownHook;
import org.springframework.boot.SpringBootExceptionHandler;
import org.springframework.boot.SpringBootExceptionReporter;
import org.springframework.boot.StartupInfoLogger;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.BindableRuntimeHintsRegistrar;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.aot.AotApplicationContextInitializer;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.ThrowingConsumer;
import org.springframework.util.function.ThrowingSupplier;

public class SpringApplication {
    public static final String BANNER_LOCATION_PROPERTY_VALUE = "banner.txt";
    public static final String BANNER_LOCATION_PROPERTY = "spring.banner.location";
    private static final String SYSTEM_PROPERTY_JAVA_AWT_HEADLESS = "java.awt.headless";
    private static final Log logger = LogFactory.getLog(SpringApplication.class);
    static final SpringApplicationShutdownHook shutdownHook = new SpringApplicationShutdownHook();
    private static final ThreadLocal<SpringApplicationHook> applicationHook = new ThreadLocal();
    private final Set<Class<?>> primarySources;
    private Set<String> sources = new LinkedHashSet<String>();
    private Class<?> mainApplicationClass;
    private Banner.Mode bannerMode = Banner.Mode.CONSOLE;
    private boolean logStartupInfo = true;
    private boolean addCommandLineProperties = true;
    private boolean addConversionService = true;
    private Banner banner;
    private ResourceLoader resourceLoader;
    private BeanNameGenerator beanNameGenerator;
    private ConfigurableEnvironment environment;
    private WebApplicationType webApplicationType;
    private boolean headless = true;
    private boolean registerShutdownHook = true;
    private List<ApplicationContextInitializer<?>> initializers;
    private List<ApplicationListener<?>> listeners;
    private Map<String, Object> defaultProperties;
    private final List<BootstrapRegistryInitializer> bootstrapRegistryInitializers;
    private Set<String> additionalProfiles = Collections.emptySet();
    private boolean allowBeanDefinitionOverriding;
    private boolean allowCircularReferences;
    private boolean isCustomEnvironment = false;
    private boolean lazyInitialization = false;
    private String environmentPrefix;
    private ApplicationContextFactory applicationContextFactory = ApplicationContextFactory.DEFAULT;
    private ApplicationStartup applicationStartup = ApplicationStartup.DEFAULT;

    public SpringApplication(Class<?> ... primarySources) {
        this((ResourceLoader)null, primarySources);
    }

    public SpringApplication(ResourceLoader resourceLoader, Class<?> ... primarySources) {
        this.resourceLoader = resourceLoader;
        Assert.notNull(primarySources, "PrimarySources must not be null");
        this.primarySources = new LinkedHashSet(Arrays.asList(primarySources));
        this.webApplicationType = WebApplicationType.deduceFromClasspath();
        this.bootstrapRegistryInitializers = new ArrayList<BootstrapRegistryInitializer>(this.getSpringFactoriesInstances(BootstrapRegistryInitializer.class));
        this.setInitializers(this.getSpringFactoriesInstances(ApplicationContextInitializer.class));
        this.setListeners(this.getSpringFactoriesInstances(ApplicationListener.class));
        this.mainApplicationClass = this.deduceMainApplicationClass();
    }

    private Class<?> deduceMainApplicationClass() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(this::findMainClass).orElse(null);
    }

    private Optional<Class<?>> findMainClass(Stream<StackWalker.StackFrame> stack) {
        return stack.filter(frame -> Objects.equals(frame.getMethodName(), "main")).findFirst().map(StackWalker.StackFrame::getDeclaringClass);
    }

    public ConfigurableApplicationContext run(String ... args) {
        if (this.registerShutdownHook) {
            shutdownHook.enableShutdowHookAddition();
        }
        long startTime = System.nanoTime();
        DefaultBootstrapContext bootstrapContext = this.createBootstrapContext();
        ConfigurableApplicationContext context = null;
        this.configureHeadlessProperty();
        SpringApplicationRunListeners listeners = this.getRunListeners(args);
        listeners.starting(bootstrapContext, this.mainApplicationClass);
        try {
            DefaultApplicationArguments applicationArguments = new DefaultApplicationArguments(args);
            ConfigurableEnvironment environment2 = this.prepareEnvironment(listeners, bootstrapContext, applicationArguments);
            Banner printedBanner = this.printBanner(environment2);
            context = this.createApplicationContext();
            context.setApplicationStartup(this.applicationStartup);
            this.prepareContext(bootstrapContext, context, environment2, listeners, applicationArguments, printedBanner);
            this.refreshContext(context);
            this.afterRefresh(context, applicationArguments);
            Duration timeTakenToStartup = Duration.ofNanos(System.nanoTime() - startTime);
            if (this.logStartupInfo) {
                new StartupInfoLogger(this.mainApplicationClass).logStarted(this.getApplicationLog(), timeTakenToStartup);
            }
            listeners.started(context, timeTakenToStartup);
            this.callRunners(context, applicationArguments);
        }
        catch (Throwable ex) {
            if (ex instanceof AbandonedRunException) {
                throw ex;
            }
            this.handleRunFailure(context, ex, listeners);
            throw new IllegalStateException(ex);
        }
        try {
            if (context.isRunning()) {
                Duration timeTakenToReady = Duration.ofNanos(System.nanoTime() - startTime);
                listeners.ready(context, timeTakenToReady);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof AbandonedRunException) {
                throw ex;
            }
            this.handleRunFailure(context, ex, null);
            throw new IllegalStateException(ex);
        }
        return context;
    }

    private DefaultBootstrapContext createBootstrapContext() {
        DefaultBootstrapContext bootstrapContext = new DefaultBootstrapContext();
        this.bootstrapRegistryInitializers.forEach(initializer -> initializer.initialize(bootstrapContext));
        return bootstrapContext;
    }

    private ConfigurableEnvironment prepareEnvironment(SpringApplicationRunListeners listeners, DefaultBootstrapContext bootstrapContext, ApplicationArguments applicationArguments) {
        ConfigurableEnvironment environment2 = this.getOrCreateEnvironment();
        this.configureEnvironment(environment2, applicationArguments.getSourceArgs());
        ConfigurationPropertySources.attach(environment2);
        listeners.environmentPrepared(bootstrapContext, environment2);
        DefaultPropertiesPropertySource.moveToEnd(environment2);
        Assert.state(!environment2.containsProperty("spring.main.environment-prefix"), "Environment prefix cannot be set via properties.");
        this.bindToSpringApplication(environment2);
        if (!this.isCustomEnvironment) {
            EnvironmentConverter environmentConverter = new EnvironmentConverter(this.getClassLoader());
            environment2 = environmentConverter.convertEnvironmentIfNecessary(environment2, this.deduceEnvironmentClass());
        }
        ConfigurationPropertySources.attach(environment2);
        return environment2;
    }

    private Class<? extends ConfigurableEnvironment> deduceEnvironmentClass() {
        Class<? extends ConfigurableEnvironment> environmentType = this.applicationContextFactory.getEnvironmentType(this.webApplicationType);
        if (environmentType == null && this.applicationContextFactory != ApplicationContextFactory.DEFAULT) {
            environmentType = ApplicationContextFactory.DEFAULT.getEnvironmentType(this.webApplicationType);
        }
        if (environmentType == null) {
            return ApplicationEnvironment.class;
        }
        return environmentType;
    }

    private void prepareContext(DefaultBootstrapContext bootstrapContext, ConfigurableApplicationContext context, ConfigurableEnvironment environment2, SpringApplicationRunListeners listeners, ApplicationArguments applicationArguments, Banner printedBanner) {
        context.setEnvironment(environment2);
        this.postProcessApplicationContext(context);
        this.addAotGeneratedInitializerIfNecessary(this.initializers);
        this.applyInitializers(context);
        listeners.contextPrepared(context);
        bootstrapContext.close(context);
        if (this.logStartupInfo) {
            this.logStartupInfo(context.getParent() == null);
            this.logStartupProfileInfo(context);
        }
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        beanFactory.registerSingleton("springApplicationArguments", applicationArguments);
        if (printedBanner != null) {
            beanFactory.registerSingleton("springBootBanner", printedBanner);
        }
        if (beanFactory instanceof AbstractAutowireCapableBeanFactory) {
            AbstractAutowireCapableBeanFactory autowireCapableBeanFactory = (AbstractAutowireCapableBeanFactory)((Object)beanFactory);
            autowireCapableBeanFactory.setAllowCircularReferences(this.allowCircularReferences);
            if (beanFactory instanceof DefaultListableBeanFactory) {
                DefaultListableBeanFactory listableBeanFactory = (DefaultListableBeanFactory)beanFactory;
                listableBeanFactory.setAllowBeanDefinitionOverriding(this.allowBeanDefinitionOverriding);
            }
        }
        if (this.lazyInitialization) {
            context.addBeanFactoryPostProcessor(new LazyInitializationBeanFactoryPostProcessor());
        }
        context.addBeanFactoryPostProcessor(new PropertySourceOrderingBeanFactoryPostProcessor(context));
        if (!AotDetector.useGeneratedArtifacts()) {
            Set<Object> sources = this.getAllSources();
            Assert.notEmpty(sources, "Sources must not be empty");
            this.load(context, sources.toArray(new Object[0]));
        }
        listeners.contextLoaded(context);
    }

    private void addAotGeneratedInitializerIfNecessary(List<ApplicationContextInitializer<?>> initializers) {
        if (AotDetector.useGeneratedArtifacts()) {
            ArrayList<ApplicationContextInitializer> aotInitializers = new ArrayList<ApplicationContextInitializer>(initializers.stream().filter(AotApplicationContextInitializer.class::isInstance).toList());
            if (aotInitializers.isEmpty()) {
                String initializerClassName = this.mainApplicationClass.getName() + "__ApplicationContextInitializer";
                aotInitializers.add(AotApplicationContextInitializer.forInitializerClasses(initializerClassName));
            }
            initializers.removeAll(aotInitializers);
            initializers.addAll(0, aotInitializers);
        }
    }

    private void refreshContext(ConfigurableApplicationContext context) {
        if (this.registerShutdownHook) {
            shutdownHook.registerApplicationContext(context);
        }
        this.refresh(context);
    }

    private void configureHeadlessProperty() {
        System.setProperty(SYSTEM_PROPERTY_JAVA_AWT_HEADLESS, System.getProperty(SYSTEM_PROPERTY_JAVA_AWT_HEADLESS, Boolean.toString(this.headless)));
    }

    private SpringApplicationRunListeners getRunListeners(String[] args) {
        SpringApplicationRunListener hookListener;
        SpringFactoriesLoader.ArgumentResolver argumentResolver = SpringFactoriesLoader.ArgumentResolver.of(SpringApplication.class, this);
        argumentResolver = argumentResolver.and(String[].class, args);
        List<SpringApplicationRunListener> listeners = this.getSpringFactoriesInstances(SpringApplicationRunListener.class, argumentResolver);
        SpringApplicationHook hook = applicationHook.get();
        SpringApplicationRunListener springApplicationRunListener = hookListener = hook != null ? hook.getRunListener(this) : null;
        if (hookListener != null) {
            listeners = new ArrayList<SpringApplicationRunListener>(listeners);
            listeners.add(hookListener);
        }
        return new SpringApplicationRunListeners(logger, listeners, this.applicationStartup);
    }

    private <T> List<T> getSpringFactoriesInstances(Class<T> type) {
        return this.getSpringFactoriesInstances(type, null);
    }

    private <T> List<T> getSpringFactoriesInstances(Class<T> type, SpringFactoriesLoader.ArgumentResolver argumentResolver) {
        return SpringFactoriesLoader.forDefaultResourceLocation(this.getClassLoader()).load(type, argumentResolver);
    }

    private ConfigurableEnvironment getOrCreateEnvironment() {
        if (this.environment != null) {
            return this.environment;
        }
        ConfigurableEnvironment environment2 = this.applicationContextFactory.createEnvironment(this.webApplicationType);
        if (environment2 == null && this.applicationContextFactory != ApplicationContextFactory.DEFAULT) {
            environment2 = ApplicationContextFactory.DEFAULT.createEnvironment(this.webApplicationType);
        }
        return environment2 != null ? environment2 : new ApplicationEnvironment();
    }

    protected void configureEnvironment(ConfigurableEnvironment environment2, String[] args) {
        if (this.addConversionService) {
            environment2.setConversionService(new ApplicationConversionService());
        }
        this.configurePropertySources(environment2, args);
        this.configureProfiles(environment2, args);
    }

    protected void configurePropertySources(ConfigurableEnvironment environment2, String[] args) {
        MutablePropertySources sources = environment2.getPropertySources();
        if (!CollectionUtils.isEmpty(this.defaultProperties)) {
            DefaultPropertiesPropertySource.addOrMerge(this.defaultProperties, sources);
        }
        if (this.addCommandLineProperties && args.length > 0) {
            String name = "commandLineArgs";
            if (sources.contains(name)) {
                PropertySource<?> source = sources.get(name);
                CompositePropertySource composite = new CompositePropertySource(name);
                composite.addPropertySource(new SimpleCommandLinePropertySource("springApplicationCommandLineArgs", args));
                composite.addPropertySource(source);
                sources.replace(name, composite);
            } else {
                sources.addFirst(new SimpleCommandLinePropertySource(args));
            }
        }
    }

    protected void configureProfiles(ConfigurableEnvironment environment2, String[] args) {
    }

    protected void bindToSpringApplication(ConfigurableEnvironment environment2) {
        try {
            Binder.get(environment2).bind("spring.main", Bindable.ofInstance(this));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot bind to SpringApplication", ex);
        }
    }

    private Banner printBanner(ConfigurableEnvironment environment2) {
        if (this.bannerMode == Banner.Mode.OFF) {
            return null;
        }
        ResourceLoader resourceLoader = this.resourceLoader != null ? this.resourceLoader : new DefaultResourceLoader(null);
        SpringApplicationBannerPrinter bannerPrinter = new SpringApplicationBannerPrinter(resourceLoader, this.banner);
        if (this.bannerMode == Banner.Mode.LOG) {
            return bannerPrinter.print((Environment)environment2, this.mainApplicationClass, logger);
        }
        return bannerPrinter.print((Environment)environment2, this.mainApplicationClass, System.out);
    }

    protected ConfigurableApplicationContext createApplicationContext() {
        return this.applicationContextFactory.create(this.webApplicationType);
    }

    protected void postProcessApplicationContext(ConfigurableApplicationContext context) {
        if (this.beanNameGenerator != null) {
            context.getBeanFactory().registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", this.beanNameGenerator);
        }
        if (this.resourceLoader != null) {
            if (context instanceof GenericApplicationContext) {
                GenericApplicationContext genericApplicationContext = (GenericApplicationContext)context;
                genericApplicationContext.setResourceLoader(this.resourceLoader);
            }
            if (context instanceof DefaultResourceLoader) {
                DefaultResourceLoader defaultResourceLoader = (DefaultResourceLoader)((Object)context);
                defaultResourceLoader.setClassLoader(this.resourceLoader.getClassLoader());
            }
        }
        if (this.addConversionService) {
            context.getBeanFactory().setConversionService(context.getEnvironment().getConversionService());
        }
    }

    protected void applyInitializers(ConfigurableApplicationContext context) {
        for (ApplicationContextInitializer<?> initializer : this.getInitializers()) {
            Class<?> requiredType = GenericTypeResolver.resolveTypeArgument(initializer.getClass(), ApplicationContextInitializer.class);
            Assert.isInstanceOf(requiredType, (Object)context, "Unable to call initializer.");
            initializer.initialize(context);
        }
    }

    protected void logStartupInfo(boolean isRoot) {
        if (isRoot) {
            new StartupInfoLogger(this.mainApplicationClass).logStarting(this.getApplicationLog());
        }
    }

    protected void logStartupProfileInfo(ConfigurableApplicationContext context) {
        Log log = this.getApplicationLog();
        if (log.isInfoEnabled()) {
            List<String> activeProfiles = this.quoteProfiles(context.getEnvironment().getActiveProfiles());
            if (ObjectUtils.isEmpty(activeProfiles)) {
                List<String> defaultProfiles = this.quoteProfiles(context.getEnvironment().getDefaultProfiles());
                String message = String.format("%s default %s: ", defaultProfiles.size(), defaultProfiles.size() <= 1 ? "profile" : "profiles");
                log.info("No active profile set, falling back to " + message + StringUtils.collectionToDelimitedString(defaultProfiles, ", "));
            } else {
                String message = activeProfiles.size() == 1 ? "1 profile is active: " : activeProfiles.size() + " profiles are active: ";
                log.info("The following " + message + StringUtils.collectionToDelimitedString(activeProfiles, ", "));
            }
        }
    }

    private List<String> quoteProfiles(String[] profiles) {
        return Arrays.stream(profiles).map(profile2 -> "\"" + profile2 + "\"").toList();
    }

    protected Log getApplicationLog() {
        if (this.mainApplicationClass == null) {
            return logger;
        }
        return LogFactory.getLog(this.mainApplicationClass);
    }

    protected void load(ApplicationContext context, Object[] sources) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading source " + StringUtils.arrayToCommaDelimitedString(sources));
        }
        BeanDefinitionLoader loader = this.createBeanDefinitionLoader(this.getBeanDefinitionRegistry(context), sources);
        if (this.beanNameGenerator != null) {
            loader.setBeanNameGenerator(this.beanNameGenerator);
        }
        if (this.resourceLoader != null) {
            loader.setResourceLoader(this.resourceLoader);
        }
        if (this.environment != null) {
            loader.setEnvironment(this.environment);
        }
        loader.load();
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)((Object)context);
            return registry;
        }
        if (context instanceof AbstractApplicationContext) {
            AbstractApplicationContext abstractApplicationContext = (AbstractApplicationContext)context;
            return (BeanDefinitionRegistry)((Object)abstractApplicationContext.getBeanFactory());
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    protected BeanDefinitionLoader createBeanDefinitionLoader(BeanDefinitionRegistry registry, Object[] sources) {
        return new BeanDefinitionLoader(registry, sources);
    }

    protected void refresh(ConfigurableApplicationContext applicationContext) {
        applicationContext.refresh();
    }

    protected void afterRefresh(ConfigurableApplicationContext context, ApplicationArguments args) {
    }

    private void callRunners(ApplicationContext context, ApplicationArguments args) {
        context.getBeanProvider(Runner.class).orderedStream().forEach(runner -> {
            if (runner instanceof ApplicationRunner) {
                ApplicationRunner applicationRunner = (ApplicationRunner)runner;
                this.callRunner(applicationRunner, args);
            }
            if (runner instanceof CommandLineRunner) {
                CommandLineRunner commandLineRunner = (CommandLineRunner)runner;
                this.callRunner(commandLineRunner, args);
            }
        });
    }

    private void callRunner(ApplicationRunner runner, ApplicationArguments args) {
        try {
            runner.run(args);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to execute ApplicationRunner", ex);
        }
    }

    private void callRunner(CommandLineRunner runner, ApplicationArguments args) {
        try {
            runner.run(args.getSourceArgs());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to execute CommandLineRunner", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRunFailure(ConfigurableApplicationContext context, Throwable exception, SpringApplicationRunListeners listeners) {
        try {
            try {
                this.handleExitCode(context, exception);
                if (listeners != null) {
                    listeners.failed(context, exception);
                }
            }
            finally {
                this.reportFailure(this.getExceptionReporters(context), exception);
                if (context != null) {
                    context.close();
                    shutdownHook.deregisterFailedApplicationContext(context);
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Unable to close ApplicationContext", ex);
        }
        ReflectionUtils.rethrowRuntimeException(exception);
    }

    private Collection<SpringBootExceptionReporter> getExceptionReporters(ConfigurableApplicationContext context) {
        try {
            SpringFactoriesLoader.ArgumentResolver argumentResolver = SpringFactoriesLoader.ArgumentResolver.of(ConfigurableApplicationContext.class, context);
            return this.getSpringFactoriesInstances(SpringBootExceptionReporter.class, argumentResolver);
        }
        catch (Throwable ex) {
            return Collections.emptyList();
        }
    }

    private void reportFailure(Collection<SpringBootExceptionReporter> exceptionReporters, Throwable failure) {
        try {
            for (SpringBootExceptionReporter reporter : exceptionReporters) {
                if (!reporter.reportException(failure)) continue;
                this.registerLoggedException(failure);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (logger.isErrorEnabled()) {
            logger.error("Application run failed", failure);
            this.registerLoggedException(failure);
        }
    }

    protected void registerLoggedException(Throwable exception) {
        SpringBootExceptionHandler handler = this.getSpringBootExceptionHandler();
        if (handler != null) {
            handler.registerLoggedException(exception);
        }
    }

    private void handleExitCode(ConfigurableApplicationContext context, Throwable exception) {
        int exitCode = this.getExitCodeFromException(context, exception);
        if (exitCode != 0) {
            SpringBootExceptionHandler handler;
            if (context != null) {
                context.publishEvent(new ExitCodeEvent((Object)context, exitCode));
            }
            if ((handler = this.getSpringBootExceptionHandler()) != null) {
                handler.registerExitCode(exitCode);
            }
        }
    }

    private int getExitCodeFromException(ConfigurableApplicationContext context, Throwable exception) {
        int exitCode = this.getExitCodeFromMappedException(context, exception);
        if (exitCode == 0) {
            exitCode = this.getExitCodeFromExitCodeGeneratorException(exception);
        }
        return exitCode;
    }

    private int getExitCodeFromMappedException(ConfigurableApplicationContext context, Throwable exception) {
        if (context == null || !context.isActive()) {
            return 0;
        }
        ExitCodeGenerators generators = new ExitCodeGenerators();
        Collection<ExitCodeExceptionMapper> beans2 = context.getBeansOfType(ExitCodeExceptionMapper.class).values();
        generators.addAll(exception, beans2);
        return generators.getExitCode();
    }

    private int getExitCodeFromExitCodeGeneratorException(Throwable exception) {
        if (exception == null) {
            return 0;
        }
        if (exception instanceof ExitCodeGenerator) {
            ExitCodeGenerator generator = (ExitCodeGenerator)((Object)exception);
            return generator.getExitCode();
        }
        return this.getExitCodeFromExitCodeGeneratorException(exception.getCause());
    }

    SpringBootExceptionHandler getSpringBootExceptionHandler() {
        if (this.isMainThread(Thread.currentThread())) {
            return SpringBootExceptionHandler.forCurrentThread();
        }
        return null;
    }

    private boolean isMainThread(Thread currentThread) {
        return ("main".equals(currentThread.getName()) || "restartedMain".equals(currentThread.getName())) && "main".equals(currentThread.getThreadGroup().getName());
    }

    public Class<?> getMainApplicationClass() {
        return this.mainApplicationClass;
    }

    public void setMainApplicationClass(Class<?> mainApplicationClass) {
        this.mainApplicationClass = mainApplicationClass;
    }

    public WebApplicationType getWebApplicationType() {
        return this.webApplicationType;
    }

    public void setWebApplicationType(WebApplicationType webApplicationType) {
        Assert.notNull((Object)webApplicationType, "WebApplicationType must not be null");
        this.webApplicationType = webApplicationType;
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public void setAllowCircularReferences(boolean allowCircularReferences) {
        this.allowCircularReferences = allowCircularReferences;
    }

    public void setLazyInitialization(boolean lazyInitialization) {
        this.lazyInitialization = lazyInitialization;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void setRegisterShutdownHook(boolean registerShutdownHook) {
        this.registerShutdownHook = registerShutdownHook;
    }

    public void setBanner(Banner banner) {
        this.banner = banner;
    }

    public void setBannerMode(Banner.Mode bannerMode) {
        this.bannerMode = bannerMode;
    }

    public void setLogStartupInfo(boolean logStartupInfo) {
        this.logStartupInfo = logStartupInfo;
    }

    public void setAddCommandLineProperties(boolean addCommandLineProperties) {
        this.addCommandLineProperties = addCommandLineProperties;
    }

    public void setAddConversionService(boolean addConversionService) {
        this.addConversionService = addConversionService;
    }

    public void addBootstrapRegistryInitializer(BootstrapRegistryInitializer bootstrapRegistryInitializer) {
        Assert.notNull((Object)bootstrapRegistryInitializer, "BootstrapRegistryInitializer must not be null");
        this.bootstrapRegistryInitializers.addAll(Arrays.asList(bootstrapRegistryInitializer));
    }

    public void setDefaultProperties(Map<String, Object> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setDefaultProperties(Properties defaultProperties) {
        this.defaultProperties = new HashMap<String, Object>();
        for (Object key : Collections.list(defaultProperties.propertyNames())) {
            this.defaultProperties.put((String)key, defaultProperties.get(key));
        }
    }

    public void setAdditionalProfiles(String ... profiles) {
        this.additionalProfiles = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(profiles)));
    }

    public Set<String> getAdditionalProfiles() {
        return this.additionalProfiles;
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    public void setEnvironment(ConfigurableEnvironment environment2) {
        this.isCustomEnvironment = true;
        this.environment = environment2;
    }

    public void addPrimarySources(Collection<Class<?>> additionalPrimarySources) {
        this.primarySources.addAll(additionalPrimarySources);
    }

    public Set<String> getSources() {
        return this.sources;
    }

    public void setSources(Set<String> sources) {
        Assert.notNull(sources, "Sources must not be null");
        this.sources = new LinkedHashSet<String>(sources);
    }

    public Set<Object> getAllSources() {
        LinkedHashSet<Object> allSources = new LinkedHashSet<Object>();
        if (!CollectionUtils.isEmpty(this.primarySources)) {
            allSources.addAll(this.primarySources);
        }
        if (!CollectionUtils.isEmpty(this.sources)) {
            allSources.addAll(this.sources);
        }
        return Collections.unmodifiableSet(allSources);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public String getEnvironmentPrefix() {
        return this.environmentPrefix;
    }

    public void setEnvironmentPrefix(String environmentPrefix) {
        this.environmentPrefix = environmentPrefix;
    }

    public void setApplicationContextFactory(ApplicationContextFactory applicationContextFactory) {
        this.applicationContextFactory = applicationContextFactory != null ? applicationContextFactory : ApplicationContextFactory.DEFAULT;
    }

    public void setInitializers(Collection<? extends ApplicationContextInitializer<?>> initializers) {
        this.initializers = new ArrayList(initializers);
    }

    public void addInitializers(ApplicationContextInitializer<?> ... initializers) {
        this.initializers.addAll(Arrays.asList(initializers));
    }

    public Set<ApplicationContextInitializer<?>> getInitializers() {
        return SpringApplication.asUnmodifiableOrderedSet(this.initializers);
    }

    public void setListeners(Collection<? extends ApplicationListener<?>> listeners) {
        this.listeners = new ArrayList(listeners);
    }

    public void addListeners(ApplicationListener<?> ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
    }

    public Set<ApplicationListener<?>> getListeners() {
        return SpringApplication.asUnmodifiableOrderedSet(this.listeners);
    }

    public void setApplicationStartup(ApplicationStartup applicationStartup) {
        this.applicationStartup = applicationStartup != null ? applicationStartup : ApplicationStartup.DEFAULT;
    }

    public ApplicationStartup getApplicationStartup() {
        return this.applicationStartup;
    }

    public static SpringApplicationShutdownHandlers getShutdownHandlers() {
        return shutdownHook.getHandlers();
    }

    public static ConfigurableApplicationContext run(Class<?> primarySource, String ... args) {
        return SpringApplication.run(new Class[]{primarySource}, args);
    }

    public static ConfigurableApplicationContext run(Class<?>[] primarySources, String[] args) {
        return new SpringApplication(primarySources).run(args);
    }

    public static void main(String[] args) throws Exception {
        SpringApplication.run(new Class[0], args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int exit(ApplicationContext context, ExitCodeGenerator ... exitCodeGenerators) {
        Assert.notNull((Object)context, "Context must not be null");
        int exitCode = 0;
        try {
            try {
                ExitCodeGenerators generators = new ExitCodeGenerators();
                Collection<ExitCodeGenerator> beans2 = context.getBeansOfType(ExitCodeGenerator.class).values();
                generators.addAll(exitCodeGenerators);
                generators.addAll(beans2);
                exitCode = generators.getExitCode();
                if (exitCode != 0) {
                    context.publishEvent(new ExitCodeEvent((Object)context, exitCode));
                }
            }
            finally {
                SpringApplication.close(context);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exitCode = exitCode != 0 ? exitCode : 1;
        }
        return exitCode;
    }

    public static Augmented from(ThrowingConsumer<String[]> main) {
        Assert.notNull(main, "Main must not be null");
        return new Augmented(main, Collections.emptySet());
    }

    public static void withHook(SpringApplicationHook hook, Runnable action) {
        SpringApplication.withHook(hook, () -> {
            action.run();
            return null;
        });
    }

    public static <T> T withHook(SpringApplicationHook hook, ThrowingSupplier<T> action) {
        applicationHook.set(hook);
        try {
            T t = action.get();
            return t;
        }
        finally {
            applicationHook.remove();
        }
    }

    private static void close(ApplicationContext context) {
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext closable = (ConfigurableApplicationContext)context;
            closable.close();
        }
    }

    private static <E> Set<E> asUnmodifiableOrderedSet(Collection<E> elements) {
        ArrayList<Object> list = new ArrayList<Object>(elements);
        list.sort(AnnotationAwareOrderComparator.INSTANCE);
        return new LinkedHashSet<E>(list);
    }

    public static class AbandonedRunException
    extends RuntimeException {
        private final ConfigurableApplicationContext applicationContext;

        public AbandonedRunException() {
            this((ConfigurableApplicationContext)null);
        }

        public AbandonedRunException(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        public ConfigurableApplicationContext getApplicationContext() {
            return this.applicationContext;
        }
    }

    private static class PropertySourceOrderingBeanFactoryPostProcessor
    implements BeanFactoryPostProcessor,
    Ordered {
        private final ConfigurableApplicationContext context;

        PropertySourceOrderingBeanFactoryPostProcessor(ConfigurableApplicationContext context) {
            this.context = context;
        }

        @Override
        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        @Override
        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            DefaultPropertiesPropertySource.moveToEnd(this.context.getEnvironment());
        }
    }

    public static class Augmented {
        private final ThrowingConsumer<String[]> main;
        private final Set<Class<?>> sources;

        Augmented(ThrowingConsumer<String[]> main, Set<Class<?>> sources) {
            this.main = main;
            this.sources = Set.copyOf(sources);
        }

        public Augmented with(Class<?> ... sources) {
            LinkedHashSet merged = new LinkedHashSet(this.sources);
            merged.addAll(Arrays.asList(sources));
            return new Augmented(this.main, merged);
        }

        public Running run(String ... args) {
            RunListener runListener = new RunListener();
            SingleUseSpringApplicationHook hook = new SingleUseSpringApplicationHook(springApplication -> {
                springApplication.addPrimarySources(this.sources);
                return runListener;
            });
            SpringApplication.withHook((SpringApplicationHook)hook, () -> this.main.accept(args));
            return runListener;
        }

        private static class RunListener
        implements SpringApplicationRunListener,
        Running {
            private final List<ConfigurableApplicationContext> contexts = Collections.synchronizedList(new ArrayList());

            private RunListener() {
            }

            @Override
            public void contextLoaded(ConfigurableApplicationContext context) {
                this.contexts.add(context);
            }

            @Override
            public ConfigurableApplicationContext getApplicationContext() {
                List<ConfigurableApplicationContext> rootContexts = this.contexts.stream().filter(context -> context.getParent() == null).toList();
                Assert.state(!rootContexts.isEmpty(), "No root application context located");
                Assert.state(rootContexts.size() == 1, "No unique root application context located");
                return rootContexts.get(0);
            }
        }
    }

    private static final class SingleUseSpringApplicationHook
    implements SpringApplicationHook {
        private final AtomicBoolean used = new AtomicBoolean();
        private final SpringApplicationHook delegate;

        private SingleUseSpringApplicationHook(SpringApplicationHook delegate) {
            this.delegate = delegate;
        }

        @Override
        public SpringApplicationRunListener getRunListener(SpringApplication springApplication) {
            return this.used.compareAndSet(false, true) ? this.delegate.getRunListener(springApplication) : null;
        }
    }

    static class SpringApplicationRuntimeHints
    extends BindableRuntimeHintsRegistrar {
        SpringApplicationRuntimeHints() {
            super(SpringApplication.class);
        }
    }

    public static interface Running {
        public ConfigurableApplicationContext getApplicationContext();
    }
}

