/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.ByteUtils;

public class FetchSnapshotResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    List<TopicSnapshot> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top level response error code."), new Field("topics", new CompactArrayOf(TopicSnapshot.SCHEMA_0), "The topics to fetch."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public FetchSnapshotResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public FetchSnapshotResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.topics = new ArrayList<TopicSnapshot>(0);
    }

    @Override
    public short apiKey() {
        return 59;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicSnapshot> newCollection = new ArrayList<TopicSnapshot>(arrayLength);
        for (int i2 = 0; i2 < arrayLength; ++i2) {
            newCollection.add(new TopicSnapshot(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (TopicSnapshot topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (TopicSnapshot topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FetchSnapshotResponseData)) {
            return false;
        }
        FetchSnapshotResponseData other = (FetchSnapshotResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public FetchSnapshotResponseData duplicate() {
        FetchSnapshotResponseData _duplicate = new FetchSnapshotResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        ArrayList<TopicSnapshot> newTopics = new ArrayList<TopicSnapshot>(this.topics.size());
        for (TopicSnapshot _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "FetchSnapshotResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<TopicSnapshot> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public FetchSnapshotResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public FetchSnapshotResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public FetchSnapshotResponseData setTopics(List<TopicSnapshot> v) {
        this.topics = v;
        return this;
    }

    public static class LeaderIdAndEpoch
    implements Message {
        int leaderId;
        int leaderEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("leader_id", Type.INT32, "The ID of the current leader or -1 if the leader is unknown."), new Field("leader_epoch", Type.INT32, "The latest known leader epoch"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public LeaderIdAndEpoch(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderIdAndEpoch() {
            this.leaderId = 0;
            this.leaderEpoch = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderIdAndEpoch");
            }
            this.leaderId = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.leaderId);
            _writable.writeInt(this.leaderEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderIdAndEpoch");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderIdAndEpoch)) {
                return false;
            }
            LeaderIdAndEpoch other = (LeaderIdAndEpoch)obj;
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        @Override
        public LeaderIdAndEpoch duplicate() {
            LeaderIdAndEpoch _duplicate = new LeaderIdAndEpoch();
            _duplicate.leaderId = this.leaderId;
            _duplicate.leaderEpoch = this.leaderEpoch;
            return _duplicate;
        }

        public String toString() {
            return "LeaderIdAndEpoch(leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderIdAndEpoch setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public LeaderIdAndEpoch setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }
    }

    public static class SnapshotId
    implements Message {
        long endOffset;
        int epoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("end_offset", Type.INT64, ""), new Field("epoch", Type.INT32, ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public SnapshotId(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public SnapshotId() {
            this.endOffset = 0L;
            this.epoch = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of SnapshotId");
            }
            this.endOffset = _readable.readLong();
            this.epoch = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeLong(this.endOffset);
            _writable.writeInt(this.epoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of SnapshotId");
            }
            _size.addBytes(8);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SnapshotId)) {
                return false;
            }
            SnapshotId other = (SnapshotId)obj;
            if (this.endOffset != other.endOffset) {
                return false;
            }
            if (this.epoch != other.epoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
            hashCode = 31 * hashCode + this.epoch;
            return hashCode;
        }

        @Override
        public SnapshotId duplicate() {
            SnapshotId _duplicate = new SnapshotId();
            _duplicate.endOffset = this.endOffset;
            _duplicate.epoch = this.epoch;
            return _duplicate;
        }

        public String toString() {
            return "SnapshotId(endOffset=" + this.endOffset + ", epoch=" + this.epoch + ")";
        }

        public long endOffset() {
            return this.endOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public SnapshotId setEndOffset(long v) {
            this.endOffset = v;
            return this;
        }

        public SnapshotId setEpoch(int v) {
            this.epoch = v;
            return this;
        }
    }

    public static class PartitionSnapshot
    implements Message {
        int index;
        short errorCode;
        SnapshotId snapshotId;
        LeaderIdAndEpoch currentLeader;
        long size;
        long position;
        BaseRecords unalignedRecords;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("snapshot_id", SnapshotId.SCHEMA_0, "The snapshot endOffset and epoch fetched"), new Field("size", Type.INT64, "The total size of the snapshot."), new Field("position", Type.INT64, "The starting byte position within the snapshot included in the Bytes field."), new Field("unaligned_records", Type.COMPACT_RECORDS, "Snapshot data in records format which may not be aligned on an offset boundary"), Field.TaggedFieldsSection.of(0, new Field("current_leader", LeaderIdAndEpoch.SCHEMA_0, "")));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionSnapshot(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public PartitionSnapshot() {
            this.index = 0;
            this.errorCode = 0;
            this.snapshotId = new SnapshotId();
            this.currentLeader = new LeaderIdAndEpoch();
            this.size = 0L;
            this.position = 0L;
            this.unalignedRecords = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionSnapshot");
            }
            this.index = _readable.readInt();
            this.errorCode = _readable.readShort();
            this.snapshotId = new SnapshotId(_readable, _version);
            this.currentLeader = new LeaderIdAndEpoch();
            this.size = _readable.readLong();
            this.position = _readable.readLong();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field unalignedRecords was serialized as null");
            }
            this.unalignedRecords = _readable.readRecords(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        this.currentLeader = new LeaderIdAndEpoch(_readable, _version);
                        continue block3;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.index);
            _writable.writeShort(this.errorCode);
            this.snapshotId.write(_writable, _cache, _version);
            if (!this.currentLeader.equals(new LeaderIdAndEpoch())) {
                ++_numTaggedFields;
            }
            _writable.writeLong(this.size);
            _writable.writeLong(this.position);
            _writable.writeUnsignedVarint(this.unalignedRecords.sizeInBytes() + 1);
            _writable.writeRecords(this.unalignedRecords);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            if (!this.currentLeader.equals(new LeaderIdAndEpoch())) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(this.currentLeader.size(_cache, _version));
                this.currentLeader.write(_writable, _cache, _version);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionSnapshot");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            this.snapshotId.addSize(_size, _cache, _version);
            if (!this.currentLeader.equals(new LeaderIdAndEpoch())) {
                ++_numTaggedFields;
                _size.addBytes(1);
                int _sizeBeforeStruct = _size.totalSize();
                this.currentLeader.addSize(_size, _cache, _version);
                int _structSize = _size.totalSize() - _sizeBeforeStruct;
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_structSize));
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addZeroCopyBytes(this.unalignedRecords.sizeInBytes());
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.unalignedRecords.sizeInBytes() + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionSnapshot)) {
                return false;
            }
            PartitionSnapshot other = (PartitionSnapshot)obj;
            if (this.index != other.index) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId)) {
                return false;
            }
            if (this.currentLeader == null ? other.currentLeader != null : !this.currentLeader.equals(other.currentLeader)) {
                return false;
            }
            if (this.size != other.size) {
                return false;
            }
            if (this.position != other.position) {
                return false;
            }
            if (!Objects.equals(this.unalignedRecords, other.unalignedRecords)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.index;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
            hashCode = 31 * hashCode + (this.currentLeader == null ? 0 : this.currentLeader.hashCode());
            hashCode = 31 * hashCode + ((int)(this.size >> 32) ^ (int)this.size);
            hashCode = 31 * hashCode + ((int)(this.position >> 32) ^ (int)this.position);
            hashCode = 31 * hashCode + Objects.hashCode(this.unalignedRecords);
            return hashCode;
        }

        @Override
        public PartitionSnapshot duplicate() {
            PartitionSnapshot _duplicate = new PartitionSnapshot();
            _duplicate.index = this.index;
            _duplicate.errorCode = this.errorCode;
            _duplicate.snapshotId = this.snapshotId.duplicate();
            _duplicate.currentLeader = this.currentLeader.duplicate();
            _duplicate.size = this.size;
            _duplicate.position = this.position;
            _duplicate.unalignedRecords = MemoryRecords.readableRecords(((MemoryRecords)this.unalignedRecords).buffer().duplicate());
            return _duplicate;
        }

        public String toString() {
            return "PartitionSnapshot(index=" + this.index + ", errorCode=" + this.errorCode + ", snapshotId=" + this.snapshotId.toString() + ", currentLeader=" + this.currentLeader.toString() + ", size=" + this.size + ", position=" + this.position + ", unalignedRecords=" + this.unalignedRecords + ")";
        }

        public int index() {
            return this.index;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public LeaderIdAndEpoch currentLeader() {
            return this.currentLeader;
        }

        public long size() {
            return this.size;
        }

        public long position() {
            return this.position;
        }

        public BaseRecords unalignedRecords() {
            return this.unalignedRecords;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionSnapshot setIndex(int v) {
            this.index = v;
            return this;
        }

        public PartitionSnapshot setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionSnapshot setSnapshotId(SnapshotId v) {
            this.snapshotId = v;
            return this;
        }

        public PartitionSnapshot setCurrentLeader(LeaderIdAndEpoch v) {
            this.currentLeader = v;
            return this;
        }

        public PartitionSnapshot setSize(long v) {
            this.size = v;
            return this;
        }

        public PartitionSnapshot setPosition(long v) {
            this.position = v;
            return this;
        }

        public PartitionSnapshot setUnalignedRecords(BaseRecords v) {
            this.unalignedRecords = v;
            return this;
        }
    }

    public static class TopicSnapshot
    implements Message {
        String name;
        List<PartitionSnapshot> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the topic to fetch."), new Field("partitions", new CompactArrayOf(PartitionSnapshot.SCHEMA_0), "The partitions to fetch."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicSnapshot(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicSnapshot() {
            this.name = "";
            this.partitions = new ArrayList<PartitionSnapshot>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicSnapshot");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionSnapshot> newCollection = new ArrayList<PartitionSnapshot>(arrayLength);
            for (int i2 = 0; i2 < arrayLength; ++i2) {
                newCollection.add(new PartitionSnapshot(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                PartitionSnapshot partitionsElement = (PartitionSnapshot)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicSnapshot");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionSnapshot partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicSnapshot)) {
                return false;
            }
            TopicSnapshot other = (TopicSnapshot)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicSnapshot duplicate() {
            TopicSnapshot _duplicate = new TopicSnapshot();
            _duplicate.name = this.name;
            ArrayList<PartitionSnapshot> newPartitions = new ArrayList<PartitionSnapshot>(this.partitions.size());
            for (PartitionSnapshot _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicSnapshot(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionSnapshot> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicSnapshot setName(String v) {
            this.name = v;
            return this;
        }

        public TopicSnapshot setPartitions(List<PartitionSnapshot> v) {
            this.partitions = v;
            return this;
        }
    }
}

