/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnInitializedRestarterCondition
extends SpringBootCondition {
    OnInitializedRestarterCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition("Initialized Restarter Condition", new Object[0]);
        Restarter restarter = this.getRestarter();
        if (restarter == null) {
            return ConditionOutcome.noMatch(message.because("unavailable"));
        }
        if (restarter.getInitialUrls() == null) {
            return ConditionOutcome.noMatch(message.because("initialized without URLs"));
        }
        return ConditionOutcome.match(message.because("available and initialized"));
    }

    private Restarter getRestarter() {
        try {
            return Restarter.getInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

