/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.validation.annotation.Validated;

public class MethodValidationInterceptor
implements MethodInterceptor {
    private final Supplier<Validator> validator;

    public MethodValidationInterceptor() {
        this.validator = SingletonSupplier.of(() -> Validation.buildDefaultValidatorFactory().getValidator());
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this.validator = SingletonSupplier.of(() -> ((ValidatorFactory)validatorFactory).getValidator());
    }

    public MethodValidationInterceptor(Validator validator) {
        this.validator = () -> validator;
    }

    public MethodValidationInterceptor(Supplier<Validator> validator) {
        this.validator = validator;
    }

    @Override
    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Set result;
        if (this.isFactoryBeanMetadataMethod(invocation.getMethod())) {
            return invocation.proceed();
        }
        Class[] groups = this.determineValidationGroups(invocation);
        ExecutableValidator execVal = this.validator.get().forExecutables();
        Method methodToValidate = invocation.getMethod();
        Object target = invocation.getThis();
        if (target == null && invocation instanceof ProxyMethodInvocation) {
            ProxyMethodInvocation methodInvocation = (ProxyMethodInvocation)invocation;
            target = methodInvocation.getProxy();
        }
        Assert.state(target != null, "Target must not be null");
        try {
            result = execVal.validateParameters(target, methodToValidate, invocation.getArguments(), groups);
        }
        catch (IllegalArgumentException ex) {
            methodToValidate = BridgeMethodResolver.findBridgedMethod(ClassUtils.getMostSpecificMethod(invocation.getMethod(), target.getClass()));
            result = execVal.validateParameters(target, methodToValidate, invocation.getArguments(), groups);
        }
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
        Object returnValue = invocation.proceed();
        result = execVal.validateReturnValue(target, methodToValidate, returnValue, groups);
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
        return returnValue;
    }

    private boolean isFactoryBeanMetadataMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.isInterface()) {
            return (clazz == FactoryBean.class || clazz == SmartFactoryBean.class) && !method.getName().equals("getObject");
        }
        Class factoryBeanType = null;
        if (SmartFactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = SmartFactoryBean.class;
        } else if (FactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = FactoryBean.class;
        }
        return factoryBeanType != null && !method.getName().equals("getObject") && ClassUtils.hasMethod(factoryBeanType, method);
    }

    protected Class<?>[] determineValidationGroups(MethodInvocation invocation) {
        Validated validatedAnn = AnnotationUtils.findAnnotation(invocation.getMethod(), Validated.class);
        if (validatedAnn == null) {
            ProxyMethodInvocation methodInvocation;
            Object proxy;
            Object target = invocation.getThis();
            if (target != null) {
                validatedAnn = AnnotationUtils.findAnnotation(target.getClass(), Validated.class);
            } else if (invocation instanceof ProxyMethodInvocation && AopUtils.isAopProxy(proxy = (methodInvocation = (ProxyMethodInvocation)invocation).getProxy())) {
                Class<?> type;
                Class<?>[] classArray = AopProxyUtils.proxiedUserInterfaces(proxy);
                int n = classArray.length;
                for (int j = 0; j < n && (validatedAnn = AnnotationUtils.findAnnotation(type = classArray[j], Validated.class)) == null; ++j) {
                }
            }
        }
        return validatedAnn != null ? validatedAnn.value() : new Class[]{};
    }
}

