/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;

final class PemContent {
    private static final Pattern PEM_HEADER = Pattern.compile("-+BEGIN\\s+[^-]*-+", 2);
    private static final Pattern PEM_FOOTER = Pattern.compile("-+END\\s+[^-]*-+", 2);

    private PemContent() {
    }

    static String load(String content) {
        String string;
        if (content == null || PemContent.isPemContent(content)) {
            return content;
        }
        URL url = ResourceUtils.getURL(content);
        InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);
        try {
            string = FileCopyUtils.copyToString(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Error reading certificate or key from file '" + content + "':" + ex.getMessage(), ex);
            }
        }
        ((Reader)reader).close();
        return string;
    }

    private static boolean isPemContent(String content) {
        return content != null && PEM_HEADER.matcher(content).find() && PEM_FOOTER.matcher(content).find();
    }
}

