/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.kafka.clients.consumer.internals.CompletedFetch;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Timer;
import org.slf4j.Logger;

public class FetchBuffer
implements AutoCloseable {
    private final Logger log;
    private final ConcurrentLinkedQueue<CompletedFetch> completedFetches;
    private final Lock lock;
    private final Condition notEmptyCondition;
    private final IdempotentCloser idempotentCloser = new IdempotentCloser();
    private final AtomicBoolean wokenup = new AtomicBoolean(false);
    private CompletedFetch nextInLineFetch;

    public FetchBuffer(LogContext logContext) {
        this.log = logContext.logger(FetchBuffer.class);
        this.completedFetches = new ConcurrentLinkedQueue();
        this.lock = new ReentrantLock();
        this.notEmptyCondition = this.lock.newCondition();
    }

    boolean isEmpty() {
        try {
            this.lock.lock();
            boolean bl = this.completedFetches.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean hasCompletedFetches(Predicate<CompletedFetch> predicate) {
        try {
            this.lock.lock();
            boolean bl = this.completedFetches.stream().anyMatch(predicate);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void add(CompletedFetch completedFetch) {
        try {
            this.lock.lock();
            this.completedFetches.add(completedFetch);
            this.notEmptyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void addAll(Collection<CompletedFetch> completedFetches) {
        if (completedFetches == null || completedFetches.isEmpty()) {
            return;
        }
        try {
            this.lock.lock();
            this.completedFetches.addAll(completedFetches);
            this.notEmptyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    CompletedFetch nextInLineFetch() {
        try {
            this.lock.lock();
            CompletedFetch completedFetch = this.nextInLineFetch;
            return completedFetch;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setNextInLineFetch(CompletedFetch nextInLineFetch) {
        try {
            this.lock.lock();
            this.nextInLineFetch = nextInLineFetch;
        }
        finally {
            this.lock.unlock();
        }
    }

    CompletedFetch peek() {
        try {
            this.lock.lock();
            CompletedFetch completedFetch = this.completedFetches.peek();
            return completedFetch;
        }
        finally {
            this.lock.unlock();
        }
    }

    CompletedFetch poll() {
        try {
            this.lock.lock();
            CompletedFetch completedFetch = this.completedFetches.poll();
            return completedFetch;
        }
        finally {
            this.lock.unlock();
        }
    }

    void awaitNotEmpty(Timer timer) {
        try {
            this.lock.lock();
            while (this.isEmpty() && !this.wokenup.compareAndSet(true, false)) {
                timer.update();
                if (timer.isExpired()) {
                } else if (this.notEmptyCondition.await(timer.remainingMs(), TimeUnit.MILLISECONDS)) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptException("Timeout waiting for results from fetching records", e);
        }
        finally {
            this.lock.unlock();
            timer.update();
        }
    }

    void wakeup() {
        this.wokenup.set(true);
        try {
            this.lock.lock();
            this.notEmptyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void retainAll(Set<TopicPartition> partitions) {
        try {
            this.lock.lock();
            this.completedFetches.removeIf(cf -> this.maybeDrain(partitions, (CompletedFetch)cf));
            if (this.maybeDrain(partitions, this.nextInLineFetch)) {
                this.nextInLineFetch = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean maybeDrain(Set<TopicPartition> partitions, CompletedFetch completedFetch) {
        if (completedFetch != null && !partitions.contains(completedFetch.partition)) {
            this.log.debug("Removing {} from buffered fetch data as it is not in the set of partitions to retain ({})", (Object)completedFetch.partition, (Object)partitions);
            completedFetch.drain();
            return true;
        }
        return false;
    }

    Set<TopicPartition> bufferedPartitions() {
        try {
            this.lock.lock();
            HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
            if (this.nextInLineFetch != null && !this.nextInLineFetch.isConsumed()) {
                partitions.add(this.nextInLineFetch.partition);
            }
            this.completedFetches.forEach(cf -> partitions.add(cf.partition));
            HashSet<TopicPartition> hashSet = partitions;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.lock.lock();
            this.idempotentCloser.close(() -> this.retainAll(Collections.emptySet()), () -> this.log.warn("The fetch buffer was already closed"));
        }
        finally {
            this.lock.unlock();
        }
    }
}

