/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.MyProducer;
import com.example.TransactionInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;

@RestController
public class BankingAPI {
    private static final String SUSPICIOUS_TOPIC = "SUSPICIOUS_TOPIC";
    private static final String VALID_TOPIC = "events";
    @Autowired
    private Jedis jedis;

    @PostMapping(value={"/check-transaction"})
    public String checkTransaction(@RequestBody TransactionInfo transactionInfo) {
        String name = transactionInfo.getName();
        String location = transactionInfo.getCountry();
        double amount = transactionInfo.getBalance();
        String jsonObject = this.jedis.get(name);
        ObjectMapper objectMapper = new ObjectMapper();
        System.out.println(jsonObject);
        String country = "";
        try {
            TransactionInfo jsonTransactionInfo = objectMapper.readValue(jsonObject, TransactionInfo.class);
            System.out.println(jsonTransactionInfo.getCountry());
            country = jsonTransactionInfo.getCountry();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        System.out.println("country: " + country);
        System.out.println("location: " + location);
        if (country == null) {
            return "User not found in the database.";
        }
        if (country.equals(location)) {
            MyProducer.logTransaction(transactionInfo, VALID_TOPIC);
            return "Transaction is valid.";
        }
        MyProducer.logTransaction(transactionInfo, SUSPICIOUS_TOPIC);
        return "Transaction is suspicious.";
    }
}

