/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpLogging;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.DefaultSslInfo;
import org.springframework.http.server.reactive.NettyHeadersAdapter;
import org.springframework.http.server.reactive.ReactorUriHelper;
import org.springframework.http.server.reactive.SslInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.netty.ChannelOperationsId;
import reactor.netty.Connection;
import reactor.netty.http.server.HttpServerRequest;

class ReactorServerHttpRequest
extends AbstractServerHttpRequest {
    private static final Log logger = HttpLogging.forLogName(ReactorServerHttpRequest.class);
    private static final AtomicLong logPrefixIndex = new AtomicLong();
    private final HttpServerRequest request;
    private final NettyDataBufferFactory bufferFactory;

    public ReactorServerHttpRequest(HttpServerRequest request, NettyDataBufferFactory bufferFactory) throws URISyntaxException {
        super(HttpMethod.valueOf(request.method().name()), ReactorUriHelper.createUri(request), "", new NettyHeadersAdapter(request.requestHeaders()));
        Assert.notNull((Object)bufferFactory, "DataBufferFactory must not be null");
        this.request = request;
        this.bufferFactory = bufferFactory;
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap<String, HttpCookie>();
        for (CharSequence name : this.request.cookies().keySet()) {
            for (Cookie cookie : (Set)this.request.cookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name.toString(), cookie.value());
                cookies.add(name.toString(), httpCookie);
            }
        }
        return cookies;
    }

    @Override
    @Nullable
    public InetSocketAddress getLocalAddress() {
        return this.request.hostAddress();
    }

    @Override
    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.request.remoteAddress();
    }

    @Override
    @Nullable
    protected SslInfo initSslInfo() {
        Channel channel = ((Connection)this.request).channel();
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        if (sslHandler == null && channel.parent() != null) {
            sslHandler = (SslHandler)channel.parent().pipeline().get(SslHandler.class);
        }
        if (sslHandler != null) {
            SSLSession session = sslHandler.engine().getSession();
            return new DefaultSslInfo(session);
        }
        return null;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.request.receive().retain().map(this.bufferFactory::wrap);
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    @Override
    @Nullable
    protected String initId() {
        HttpServerRequest httpServerRequest = this.request;
        if (httpServerRequest instanceof Connection) {
            Connection connection = (Connection)httpServerRequest;
            return connection.channel().id().asShortText() + "-" + logPrefixIndex.incrementAndGet();
        }
        return null;
    }

    @Override
    protected String initLogPrefix() {
        String id = null;
        HttpServerRequest httpServerRequest = this.request;
        if (httpServerRequest instanceof ChannelOperationsId) {
            ChannelOperationsId operationsId = (ChannelOperationsId)httpServerRequest;
            String string = id = logger.isDebugEnabled() ? operationsId.asLongText() : operationsId.asShortText();
        }
        if (id != null) {
            return id;
        }
        httpServerRequest = this.request;
        if (httpServerRequest instanceof Connection) {
            Connection connection = (Connection)httpServerRequest;
            return connection.channel().id().asShortText() + "-" + logPrefixIndex.incrementAndGet();
        }
        return this.getId();
    }
}

