/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.LongSerializer;
import org.example.TransactionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyProducer {
    private static final String BOOTSTRAP_SERVERS = "192.168.184.11:9092";
    private static final Logger log = LoggerFactory.getLogger(MyProducer.class);

    public static boolean logTransaction(TransactionInfo transactionInfo, String topic) {
        log.info("Registering A Transaction for Mr/Ms : " + transactionInfo.getName());
        TransactionInfo value = transactionInfo;
        Producer<Long, TransactionInfo> kafkaProducer = MyProducer.createKafkaProducer(BOOTSTRAP_SERVERS);
        long timeStamp = System.currentTimeMillis();
        System.out.println("topic : " + topic);
        System.out.println("value : " + value);
        ProducerRecord<Long, TransactionInfo> record = new ProducerRecord<Long, TransactionInfo>(topic, timeStamp, value);
        RecordMetadata recordMetadata = null;
        try {
            recordMetadata = kafkaProducer.send(record).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Could Not Send Data to Kafka , Or Could Not Get Meta-Data");
            throw new RuntimeException(e);
        }
        log.info(String.format("Record for Mr/Ms : %s -  with (key: %s, value: %s), was sent to (partition: %d, offset: %d)", transactionInfo.getName(), record.key(), record.value(), recordMetadata.partition(), recordMetadata.offset()));
        System.out.println(String.format("Record for Mr/Ms : %s -  with (key: %s, value: %s), was sent to (partition: %d, offset: %d)", transactionInfo.getName(), record.key(), record.value(), recordMetadata.partition(), recordMetadata.offset()));
        kafkaProducer.flush();
        kafkaProducer.close();
        return true;
    }

    public static Producer<Long, TransactionInfo> createKafkaProducer(String bootstrapServers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("client.id", "events-producer");
        properties.put("key.serializer", LongSerializer.class.getName());
        properties.put("value.serializer", TransactionInfo.class.getName());
        return new KafkaProducer<Long, TransactionInfo>(properties);
    }
}

