/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.example.TransactionInfo;
import org.example.WritingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportingKafkaConsumer {
    private static final String TOPIC = "events";
    private static final String BOOTSTRAP_SERVERS = "192.168.184.11:9092";
    static final Logger log = LoggerFactory.getLogger(ReportingKafkaConsumer.class);

    public static void main(String[] args) {
        String consumerGroup = "defaultConsumerGroup";
        if (args.length == 1) {
            consumerGroup = args[0];
        }
        System.out.println("Consumer is part of consumer group " + consumerGroup);
        Consumer<Long, TransactionInfo> kafkaConsumer = ReportingKafkaConsumer.createKafkaConsumer(BOOTSTRAP_SERVERS, consumerGroup);
        ReportingKafkaConsumer.consumeMessages(TOPIC, kafkaConsumer);
    }

    public static void consumeMessages(String topic, Consumer<Long, TransactionInfo> kafkaConsumer) {
        kafkaConsumer.subscribe(Collections.singletonList(topic));
        while (true) {
            ConsumerRecords<Long, TransactionInfo> consumerRecords;
            if ((consumerRecords = kafkaConsumer.poll(Duration.ofSeconds(1L))).isEmpty()) {
                continue;
            }
            for (ConsumerRecord<Long, TransactionInfo> consumerRecord : consumerRecords) {
                TransactionInfo transactionInfo = consumerRecord.value();
                System.out.println("key : " + consumerRecord.key());
                System.out.println("Received : " + transactionInfo);
                WritingHelper writingHelper = new WritingHelper(transactionInfo);
                writingHelper.writeToLog();
                System.out.println(writingHelper);
            }
            kafkaConsumer.commitAsync();
        }
    }

    public static Consumer<Long, TransactionInfo> createKafkaConsumer(String bootstrapServers, String consumerGroup) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("key.deserializer", LongDeserializer.class.getName());
        properties.put("value.deserializer", TransactionInfo.class.getName());
        properties.put("group.id", consumerGroup);
        properties.put("enable.auto.commit", (Object)false);
        return new KafkaConsumer<Long, TransactionInfo>(properties);
    }
}

