/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.clients.producer.internals.ProducerBatch;
import org.apache.kafka.clients.producer.internals.TxnPartitionEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.slf4j.Logger;

class TxnPartitionMap {
    private final Logger log;
    private final Map<TopicPartition, TxnPartitionEntry> topicPartitions = new HashMap<TopicPartition, TxnPartitionEntry>();

    TxnPartitionMap(LogContext logContext) {
        this.log = logContext.logger(TxnPartitionMap.class);
    }

    TxnPartitionEntry get(TopicPartition topicPartition) {
        TxnPartitionEntry ent = this.topicPartitions.get(topicPartition);
        if (ent == null) {
            throw new IllegalStateException("Trying to get txnPartitionEntry for " + topicPartition + ", but it was never set for this partition.");
        }
        return ent;
    }

    TxnPartitionEntry getOrCreate(TopicPartition topicPartition) {
        return this.topicPartitions.computeIfAbsent(topicPartition, tp -> new TxnPartitionEntry((TopicPartition)tp));
    }

    boolean contains(TopicPartition topicPartition) {
        return this.topicPartitions.containsKey(topicPartition);
    }

    void reset() {
        this.topicPartitions.clear();
    }

    OptionalLong lastAckedOffset(TopicPartition topicPartition) {
        TxnPartitionEntry entry = this.topicPartitions.get(topicPartition);
        if (entry != null) {
            return entry.lastAckedOffset();
        }
        return OptionalLong.empty();
    }

    OptionalInt lastAckedSequence(TopicPartition topicPartition) {
        TxnPartitionEntry entry = this.topicPartitions.get(topicPartition);
        if (entry != null) {
            return entry.lastAckedSequence();
        }
        return OptionalInt.empty();
    }

    void startSequencesAtBeginning(TopicPartition topicPartition, ProducerIdAndEpoch newProducerIdAndEpoch) {
        TxnPartitionEntry entry = this.get(topicPartition);
        if (entry != null) {
            entry.startSequencesAtBeginning(newProducerIdAndEpoch);
        }
    }

    void remove(TopicPartition topicPartition) {
        this.topicPartitions.remove(topicPartition);
    }

    void updateLastAckedOffset(TopicPartition topicPartition, boolean isTransactional, long lastOffset) {
        OptionalLong lastAckedOffset = this.lastAckedOffset(topicPartition);
        if (!lastAckedOffset.isPresent() && !isTransactional) {
            this.getOrCreate(topicPartition);
        }
        if (lastOffset > lastAckedOffset.orElse(-1L)) {
            this.get(topicPartition).setLastAckedOffset(lastOffset);
        } else {
            this.log.trace("Partition {} keeps lastOffset at {}", (Object)topicPartition, (Object)lastOffset);
        }
    }

    void adjustSequencesDueToFailedBatch(ProducerBatch batch) {
        if (!this.contains(batch.topicPartition)) {
            return;
        }
        this.log.debug("producerId: {}, send to partition {} failed fatally. Reducing future sequence numbers by {}", batch.producerId(), batch.topicPartition, batch.recordCount);
        this.get(batch.topicPartition).adjustSequencesDueToFailedBatch(batch.baseSequence(), batch.recordCount);
    }

    int maybeUpdateLastAckedSequence(TopicPartition topicPartition, int sequence) {
        TxnPartitionEntry entry = this.topicPartitions.get(topicPartition);
        if (entry != null) {
            return entry.maybeUpdateLastAckedSequence(sequence);
        }
        return -1;
    }

    ProducerBatch nextBatchBySequence(TopicPartition topicPartition) {
        return this.get(topicPartition).nextBatchBySequence();
    }

    void removeInFlightBatch(ProducerBatch batch) {
        this.get(batch.topicPartition).removeInFlightBatch(batch);
    }
}

