/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.compress.KafkaLZ4BlockInputStream;
import org.apache.kafka.common.compress.KafkaLZ4BlockOutputStream;
import org.apache.kafka.common.compress.SnappyFactory;
import org.apache.kafka.common.compress.ZstdFactory;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ChunkedBytesStream;

public enum CompressionType {
    NONE(0, "none", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            return buffer;
        }

        @Override
        public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            return new ByteBufferInputStream(buffer);
        }
    }
    ,
    GZIP(1, "gzip", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            try {
                return new BufferedOutputStream(new GZIPOutputStream((OutputStream)buffer, 8192), 16384);
            }
            catch (Exception e) {
                throw new KafkaException(e);
            }
        }

        @Override
        public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            try {
                return new ChunkedBytesStream(new GZIPInputStream((InputStream)new ByteBufferInputStream(buffer), 8192), decompressionBufferSupplier, this.decompressionOutputSize(), false);
            }
            catch (Exception e) {
                throw new KafkaException(e);
            }
        }

        @Override
        public int decompressionOutputSize() {
            return 16384;
        }
    }
    ,
    SNAPPY(2, "snappy", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            return SnappyFactory.wrapForOutput(buffer);
        }

        @Override
        public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            return new ChunkedBytesStream(SnappyFactory.wrapForInput(buffer), decompressionBufferSupplier, this.decompressionOutputSize(), false);
        }

        @Override
        public int decompressionOutputSize() {
            return 2048;
        }
    }
    ,
    LZ4(3, "lz4", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            try {
                return new KafkaLZ4BlockOutputStream((OutputStream)buffer, messageVersion == 0);
            }
            catch (Throwable e) {
                throw new KafkaException(e);
            }
        }

        @Override
        public InputStream wrapForInput(ByteBuffer inputBuffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            try {
                return new ChunkedBytesStream(new KafkaLZ4BlockInputStream(inputBuffer, decompressionBufferSupplier, messageVersion == 0), decompressionBufferSupplier, this.decompressionOutputSize(), true);
            }
            catch (Throwable e) {
                throw new KafkaException(e);
            }
        }

        @Override
        public int decompressionOutputSize() {
            return 2048;
        }
    }
    ,
    ZSTD(4, "zstd", 1.0f){

        @Override
        public OutputStream wrapForOutput(ByteBufferOutputStream buffer, byte messageVersion) {
            return ZstdFactory.wrapForOutput(buffer);
        }

        @Override
        public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
            return new ChunkedBytesStream(ZstdFactory.wrapForInput(buffer, messageVersion, decompressionBufferSupplier), decompressionBufferSupplier, this.decompressionOutputSize(), false);
        }

        @Override
        public int decompressionOutputSize() {
            return 16384;
        }
    };

    public final byte id;
    public final String name;
    public final float rate;

    private CompressionType(byte id, String name, float rate) {
        this.id = id;
        this.name = name;
        this.rate = rate;
    }

    public abstract OutputStream wrapForOutput(ByteBufferOutputStream var1, byte var2);

    public abstract InputStream wrapForInput(ByteBuffer var1, byte var2, BufferSupplier var3);

    public int decompressionOutputSize() {
        throw new UnsupportedOperationException("Size of decompression buffer is not defined for this compression type=" + this.name);
    }

    public static CompressionType forId(int id) {
        switch (id) {
            case 0: {
                return NONE;
            }
            case 1: {
                return GZIP;
            }
            case 2: {
                return SNAPPY;
            }
            case 3: {
                return LZ4;
            }
            case 4: {
                return ZSTD;
            }
        }
        throw new IllegalArgumentException("Unknown compression type id: " + id);
    }

    public static CompressionType forName(String name) {
        if (CompressionType.NONE.name.equals(name)) {
            return NONE;
        }
        if (CompressionType.GZIP.name.equals(name)) {
            return GZIP;
        }
        if (CompressionType.SNAPPY.name.equals(name)) {
            return SNAPPY;
        }
        if (CompressionType.LZ4.name.equals(name)) {
            return LZ4;
        }
        if (CompressionType.ZSTD.name.equals(name)) {
            return ZSTD;
        }
        throw new IllegalArgumentException("Unknown compression name: " + name);
    }

    public String toString() {
        return this.name;
    }
}

