/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.example.TransactionInfo;
import org.example.WritingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportingKafkaConsumer {
    private static final String TOPIC = "events";
    private static final String BOOTSTRAP_SERVERS = "localhost:9092,localhost:9093,localhost:9094";
    static final Logger log = LoggerFactory.getLogger(ReportingKafkaConsumer.class);

    public static void main(String[] args) {
        String consumerGroup = "defaultConsumerGroup";
        if (args.length == 1) {
            consumerGroup = args[0];
        }
        System.out.println("Consumer is part of consumer group " + consumerGroup);
        Consumer<Long, String> kafkaConsumer = ReportingKafkaConsumer.createKafkaConsumer(BOOTSTRAP_SERVERS, consumerGroup);
        ReportingKafkaConsumer.consumeMessages(TOPIC, kafkaConsumer);
    }

    public static void consumeMessages(String topic, Consumer<Long, String> kafkaConsumer) {
        ObjectMapper objectMapper = new ObjectMapper();
        kafkaConsumer.subscribe(Collections.singletonList(topic));
        while (true) {
            ConsumerRecords<Long, String> consumerRecords;
            if ((consumerRecords = kafkaConsumer.poll(Duration.ofSeconds(1L))).isEmpty()) {
                continue;
            }
            for (ConsumerRecord<Long, String> consumerRecord : consumerRecords) {
                String stringJson = consumerRecord.value();
                System.out.println("key : " + consumerRecord.key());
                System.out.println("Received : " + stringJson);
                try {
                    TransactionInfo transactionInfo = objectMapper.readValue(stringJson, TransactionInfo.class);
                    WritingHelper writingHelper = new WritingHelper(transactionInfo);
                    writingHelper.writeToLog();
                    System.out.println(writingHelper);
                }
                catch (JsonProcessingException e) {
                    System.out.println("Error Parsing");
                    System.out.println(e.getMessage());
                    log.error("Could Not Parse Json in Transaction");
                }
            }
            kafkaConsumer.commitAsync();
        }
    }

    public static Consumer<Long, String> createKafkaConsumer(String bootstrapServers, String consumerGroup) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("key.deserializer", LongDeserializer.class.getName());
        properties.put("value.deserializer", StringDeserializer.class.getName());
        properties.put("group.id", consumerGroup);
        properties.put("enable.auto.commit", (Object)false);
        return new KafkaConsumer<Long, String>(properties);
    }
}

