package ObjectExchangeInCluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class Response implements Serializable {
    private class FileWordPair {
        public String fileName;
        public long freq;
    }

    private TreeMap<String, List<FileWordPair>> wordFrequencies;

    public Response() {
        wordFrequencies = new TreeMap<>();
    }

    public void addFileWordPair(String fileName, String word, long freq) {
        FileWordPair fileWordPair = new FileWordPair();
        fileWordPair.fileName = fileName;
        fileWordPair.freq = freq;
        List<FileWordPair> temp = wordFrequencies.getOrDefault(word, new ArrayList<>());
        temp.add(fileWordPair);
        wordFrequencies.put(word, temp);
    }

    public TreeMap<String, List<FileWordPair>> getWordFrequencies()
    {
        return wordFrequencies;
    }
}


