package AutoHealerAndClusterSearch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

public class TransientWorkerApplication
{
    private static final Logger logger = LoggerFactory.getLogger(TransientWorkerApplication.class);
    public static void main(String[] args)
    {
        /**
         *
         * String sshCommand = "ssh " + remoteUser + " \"java -jar " +
         *                 remoteJarFilePath + " " +
         *                 physicalNode+ " " + ///arg[0]
         *                 modifiedQuery + " " + ///arg[1]
         *                 numberOfFilesToScan + " "+ ///arg[2]
         *                 filesOffset+"\"";   ///arg[3]
         * */
        TransientWorker worker = new TransientWorker();
        String nodeNum = args[0];
        String query = args[1];
        int numberOfFilesToScan = Integer.parseInt(args[2]);
        int filesOffset = Integer.parseInt(args[3]);
        try
        {
            worker.connectToZookeeper();
        }
        catch (IOException e)
        {
            logger.warn("Cannot Connect To ZooKeeper");
            throw new RuntimeException(e);
        }
        try
        {
            worker.work(nodeNum , query , numberOfFilesToScan , filesOffset);
        }
        catch (Exception e)
        {
            logger.error("Worker Shut Down");
            System.exit(1);
        }
    }
}
