package AutoHealerAndClusterSearch;

import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;

public class TransientWorker {
    private static final String ZOOKEEPER_ADDRESS = "192.168.184.10:2181";
    private static final int SESSION_TIMEOUT = 3000;

    private final Logger logger = LoggerFactory.getLogger(TransientWorker.class);

    // Parent Znode where each worker stores an ephemeral child to indicate it is alive
    private static final String WORKERS_ZNODES_PATH = "/workers";

    private static final float CHANCE_TO_FAIL = 0.001F;

    private final Random random = new Random();
    private ZooKeeper zooKeeper;

    private String filesLocation;
    private String myName = "";
    /// regex is used to know how the information will be concatenated to encode them to onw string
    /// like : nodenum + regex+somehting+regex....
    private String regex = "^";

    public void connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(ZOOKEEPER_ADDRESS, SESSION_TIMEOUT, event -> {
        });
    }

    public void work(String nodeNum, String query, int numberOfFilesToScan, int filesOffset) throws KeeperException, InterruptedException {
        filesLocation = System.getProperty("user.dir") + "/SearchFiles";
        addChildZnode(nodeNum, numberOfFilesToScan, filesOffset);
        logger.info(myName + " is Working and responsible for " + numberOfFilesToScan + " Files");
        List<String> myFiles = getMyFiles(numberOfFilesToScan, filesOffset);
        double score = getScore(query, myFiles);
        /// send them to coordinator
    }

    private void addChildZnode(String nodeNumber, int numberOfFilesToScan, int filesOffset) throws KeeperException, InterruptedException {

        String info = nodeNumber + regex + numberOfFilesToScan + regex + filesOffset;
        myName = zooKeeper.create(WORKERS_ZNODES_PATH + "/worker_",
                info.getBytes(),
                ZooDefs.Ids.OPEN_ACL_UNSAFE,
                CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    private List<String> getMyFiles(int numberOfFilesToScan, int filesOffset)
    {
        List<String> fileNames = new ArrayList<>();

        try (DirectoryStream<Path> stream =
                     Files.newDirectoryStream(Paths.get(filesLocation))) {
            for (Path file : stream) {
                if (Files.isRegularFile(file)) {
                    fileNames.add(file.getFileName().toString());
                }
            }
        } catch (IOException e)
        {
            logger.error("Can not Access Files");
            e.printStackTrace();
        }
        int startIndex = Math.min(filesOffset, fileNames.size());
        int endIndex = Math.min(filesOffset + numberOfFilesToScan, fileNames.size());
        return fileNames.subList(startIndex, endIndex);
    }

    private double getScore(String query, List<String> myFiles)
    {
        String[] wordsToCount = query.split(".");
        Map<String , BigInteger> numberOfWordsInFile = new HashMap<>();
        Map<String, Integer> wordFrequency = new HashMap<>();
        Map<String, Integer> fileCount = new HashMap<>();
        Path filePath = Paths.get(filesLocation);
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath.toFile())))
        {
            Set<String> uniqueWords = new HashSet<>();
            String line;
            while ((line = reader.readLine()) != null)
            {
                String[] words = line.split(" ");
                for (String word : words) {
                    if (Arrays.asList(wordsToCount).contains(word))
                    {
                        wordFrequency.put(word, wordFrequency.getOrDefault(word, 0) + 1);
                        uniqueWords.add(word);
                    }
                }
            }

            for (String word : uniqueWords)
            {
                fileCount.put(word, fileCount.getOrDefault(word, 0) + 1);
            }

            return 0.0;
        }
        catch (IOException e)
        {
            logger.error("Could not Read Files , Path Problem!");
            e.printStackTrace();
            return 0.0;
        }
    }
}

