/*
 * Decompiled with CFR 0.152.
 */
package AutoHealerAndClusterSearch;

import AutoHealerAndClusterSearch.Coordinator;
import AutoHealerAndClusterSearch.TransientWorker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistry
implements Watcher {
    private static final String WORKERS_ZNODES_PATH = "/workers";
    private static final String PHYSICAL_ZNODES_PATH = "/physical_nodes";
    private static final String COORDINATOR_ZNODE_PATH = "/coordinator_node";
    private final Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
    private final ZooKeeper zooKeeper;
    private Coordinator coordinator = null;
    private TransientWorker transientWorker = null;
    private String currentZnode = null;
    private List<String> allServiceAddresses = null;
    private int numberOfInstances;

    public ServiceRegistry(ZooKeeper zooKeeper) {
        this.zooKeeper = zooKeeper;
        this.createServiceRegistryZnode();
    }

    private void createServiceRegistryZnode() {
        try {
            if (this.zooKeeper.exists(WORKERS_ZNODES_PATH, false) == null) {
                this.zooKeeper.create(WORKERS_ZNODES_PATH, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if (this.zooKeeper.exists(PHYSICAL_ZNODES_PATH, false) == null) {
                this.zooKeeper.create(PHYSICAL_ZNODES_PATH, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if (this.zooKeeper.exists(COORDINATOR_ZNODE_PATH, false) == null) {
                this.zooKeeper.create(COORDINATOR_ZNODE_PATH, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (InterruptedException | KeeperException e) {
            this.logger.error("Could NOT Create Service Registry Znode");
            e.printStackTrace();
        }
    }

    public void registerToCluster(String metadata) throws KeeperException, InterruptedException, IOException {
        if (this.currentZnode != null) {
            this.logger.info("Already registered to service registry");
        } else {
            this.currentZnode = this.zooKeeper.create("/physical_nodes/physical_node_", metadata.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            this.logger.info("Registered to service registry");
        }
        this.transientWorker = new TransientWorker(metadata);
        this.transientWorker.start();
    }

    public void registerToCoordinator(String metadata) throws InterruptedException, KeeperException, IOException {
        this.currentZnode = this.zooKeeper.create("/coordinator_node/coordinator_", metadata.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        this.logger.info("Registered to be Coordinator and I am Master !");
        this.coordinator = new Coordinator(this.zooKeeper, metadata);
        this.coordinator.start();
    }

    public void registerForUpdates() {
        try {
            this.masterJob();
        }
        catch (IOException | InterruptedException | KeeperException e) {
            this.logger.error("Could Not Do LEADER JOB !");
            e.printStackTrace();
        }
    }

    public void unregisterFromCluster() {
        try {
            if (this.currentZnode != null && this.zooKeeper.exists(this.currentZnode, false) != null) {
                this.zooKeeper.delete(this.currentZnode, -1);
            }
        }
        catch (InterruptedException | KeeperException e) {
            this.logger.error("Could Not UN-Register From Cluster !!");
            e.printStackTrace();
        }
    }

    private synchronized void masterJob() throws InterruptedException, KeeperException, IOException {
        this.updateAddresses();
    }

    private void updateAddresses() throws KeeperException, InterruptedException {
        List<String> workerZnodes = this.zooKeeper.getChildren(PHYSICAL_ZNODES_PATH, false);
        ArrayList<String> addresses = new ArrayList<String>(workerZnodes.size());
        for (String workerZnode : workerZnodes) {
            String workerFullPath = "/physical_nodes/" + workerZnode;
            Stat stat = this.zooKeeper.exists(workerFullPath, false);
            if (stat == null) continue;
            byte[] addressBytes = this.zooKeeper.getData(workerFullPath, false, stat);
            String address = new String(addressBytes);
            addresses.add(address);
        }
        this.allServiceAddresses = Collections.unmodifiableList(addresses);
        this.logger.info("The cluster addresses are: " + this.allServiceAddresses);
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case NodeChildrenChanged: {
                try {
                    this.masterJob();
                    break;
                }
                catch (IOException | InterruptedException | KeeperException e) {
                    this.logger.error("Could NOT Handle Node Children Changed Event!");
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

