/*
 * Decompiled with CFR 0.152.
 */
package AutoHealerAndClusterSearch;

import ObjectExchangeInCluster.FileWordPair;
import ObjectExchangeInCluster.SearchQueryRequest;
import ObjectExchangeInCluster.SearchQueryResponse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coordinator {
    private ZooKeeper zooKeeper;
    private static final String PHYSICAL_ZNODES_PATH = "/physical_nodes";
    private int COORDINATOR_PORT;
    private int CLUSTER_PORT = 54321;
    private String FILES_DIRECTORY = "";
    private final Logger logger = LoggerFactory.getLogger(Coordinator.class);

    public Coordinator(ZooKeeper zooKeeper, String SOCKET) {
        this.zooKeeper = zooKeeper;
        this.COORDINATOR_PORT = Integer.parseInt(SOCKET.split(":")[1]);
        this.FILES_DIRECTORY = System.getProperty("user.dir") + "/SearchFiles/";
    }

    public void start() throws IOException, InterruptedException, KeeperException {
        System.out.println("Server started on port " + this.COORDINATOR_PORT);
        this.logger.info("Server started on port " + this.COORDINATOR_PORT);
        while (true) {
            Scanner scanner = new Scanner(System.in);
            System.out.println("Enter Query To Search : ");
            String query = scanner.nextLine();
            System.out.println("Query = " + query);
            Thread clientThread = new Thread(() -> {
                SearchQueryResponse searchQueryResponseMap = this.handleClient(query);
                this.printResponsr(searchQueryResponseMap);
            });
            clientThread.start();
        }
    }

    private void printResponsr(SearchQueryResponse searchQueryResponseMap) {
        if (searchQueryResponseMap == null) {
            return;
        }
    }

    private SearchQueryResponse sendRequestToNode(SearchQueryRequest searchQueryRequest, String ipAddress) {
        SearchQueryResponse searchQueryResponse = null;
        String ip = ipAddress.split(":")[0];
        int port = Integer.parseInt(ipAddress.split(":")[1]);
        try (Socket socket = new Socket(ip, port);){
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(searchQueryRequest);
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            searchQueryResponse = (SearchQueryResponse)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("Printing Search Query Response");
        System.out.println(searchQueryResponse);
        return searchQueryResponse;
    }

    private void sendResponsesToClient(Socket clientSocket, SearchQueryResponse searchQueryResponse) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(clientSocket.getOutputStream());
            clientSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private SearchQueryResponse handleClient(String query) {
        try {
            List<SearchQueryResponse> respons = this.spreadQuery(query);
            if (respons == null) {
                System.out.println("No Nodes Are Working , Search Cannot Be Done");
                this.logger.warn("No Nodes Are Working , Search Cannot Be Done");
            }
            this.processResultsAndPrepareAnswer(respons);
        }
        catch (IOException | InterruptedException | KeeperException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void processResultsAndPrepareAnswer(List<SearchQueryResponse> respons) {
        if (respons == null) {
            return;
        }
        for (SearchQueryResponse searchQueryResponse : respons) {
            Map<String, List<FileWordPair>> treeMap = searchQueryResponse.getWordFrequencies();
            for (Map.Entry<String, List<FileWordPair>> mapEntry : treeMap.entrySet()) {
                System.out.println("The word " + mapEntry.getKey() + " is :");
                for (FileWordPair fileWordPair : mapEntry.getValue()) {
                    System.out.println(fileWordPair);
                }
            }
        }
    }

    private int countFilesInDirectory() {
        int n;
        block8: {
            Stream<Path> files = Files.list(Paths.get(this.FILES_DIRECTORY, new String[0]));
            try {
                n = (int)files.count();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            files.close();
        }
        return n;
    }

    public List<SearchQueryResponse> spreadQuery(String query) throws InterruptedException, KeeperException, IOException, ExecutionException {
        List<String> physicalZnodes = this.zooKeeper.getChildren(PHYSICAL_ZNODES_PATH, false);
        if (physicalZnodes.isEmpty()) {
            return null;
        }
        int totalFilesNumber = this.countFilesInDirectory();
        System.out.println("Files Number = " + totalFilesNumber);
        int filesNumberforNode = (totalFilesNumber + physicalZnodes.size() - 1) / physicalZnodes.size();
        int remaining = totalFilesNumber;
        int index = 0;
        int filesOffset = 0;
        ExecutorService executorService = Executors.newFixedThreadPool(physicalZnodes.size());
        ArrayList<Callable<SearchQueryResponse>> tasks = new ArrayList<Callable<SearchQueryResponse>>();
        while (remaining > 0) {
            String physicalZnode = physicalZnodes.get(index);
            Stat stat = this.zooKeeper.exists("/physical_nodes/" + physicalZnodes.get(index), false);
            if (stat == null) {
                this.logger.warn("Physical Node : " + physicalZnode + " is dowm!");
                physicalZnodes.remove(index);
                filesNumberforNode = (totalFilesNumber + physicalZnodes.size() - 1) / physicalZnodes.size();
                continue;
            }
            String ipAddress = new String(this.zooKeeper.getData("/physical_nodes/" + physicalZnodes.get(index), false, stat));
            SearchQueryRequest searchQueryRequest = new SearchQueryRequest(query, filesNumberforNode, filesOffset);
            tasks.add(() -> this.sendRequestToNode(searchQueryRequest, ipAddress));
            index = (1 + index) % physicalZnodes.size();
            filesOffset = (filesOffset + filesNumberforNode) % totalFilesNumber;
            remaining -= filesNumberforNode;
        }
        List futures = executorService.invokeAll(tasks);
        ArrayList<SearchQueryResponse> respons = new ArrayList<SearchQueryResponse>();
        for (int i = 0; i < futures.size(); ++i) {
            SearchQueryResponse searchQueryResponse = (SearchQueryResponse)futures.get(i).get();
            respons.add(searchQueryResponse);
        }
        executorService.shutdown();
        return respons;
    }
}

