/*
 * Decompiled with CFR 0.152.
 */
package AutoHealerAndClusterSearch;

import AutoHealerAndClusterSearch.OnElectionCallback;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElection
implements Watcher {
    private static final String ELECTION_NAMESPACE = "/election";
    private String currentZnodeName;
    private ZooKeeper zooKeeper;
    private final Logger logger = LoggerFactory.getLogger(LeaderElection.class);
    private String IP = "";
    private OnElectionCallback onElectionCallback;

    public LeaderElection(ZooKeeper zooKeeper, OnElectionCallback onElectionCallback) {
        this.zooKeeper = zooKeeper;
        this.onElectionCallback = onElectionCallback;
    }

    public void volunteerForLeadership(String IP) throws InterruptedException, KeeperException, UnknownHostException {
        String znodePrefix = "/election/c_";
        this.IP = IP;
        String znodeFullPath = this.zooKeeper.create(znodePrefix, IP.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        this.logger.info("My Node under Election is" + znodeFullPath);
        this.currentZnodeName = znodeFullPath.replace("/election/", "");
    }

    public void reelectLeader() throws InterruptedException, KeeperException {
        String predecessorName = "";
        Stat predecessorStat = null;
        while (predecessorStat == null) {
            List<String> children = this.zooKeeper.getChildren(ELECTION_NAMESPACE, false);
            Collections.sort(children);
            String smallestChild = children.get(0);
            if (smallestChild.equals(this.currentZnodeName)) {
                this.logger.info("I am LEADER");
                this.onElectionCallback.onElectedToBeLeader(this.IP);
                return;
            }
            this.logger.info("I am NOT LEADER");
            int predecessorIndex = children.indexOf(this.currentZnodeName) - 1;
            predecessorName = children.get(predecessorIndex);
            predecessorStat = this.zooKeeper.exists("/election/" + predecessorName, this);
        }
        this.onElectionCallback.onWorker(this.IP);
        this.logger.info("Watching znode " + predecessorName + " in ELECTION");
    }

    @Override
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case NodeDeleted: {
                try {
                    this.reelectLeader();
                    break;
                }
                catch (InterruptedException | KeeperException e) {
                    this.logger.error("Can Not Handle Node Deletion in Election");
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

