package GRPCConnection.GRPCClient;



import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.AutoHealerAndClusterSearch.SearchReply;
import org.AutoHealerAndClusterSearch.SearchRequest;
import org.AutoHealerAndClusterSearch.SearchServiceGrpc;

import java.util.List;

/**
 * the client here will be the web server
 * configure it later
 * */
public class GRPCClient
{
    public static void main(String[] args)
    {
        ManagedChannel channel = ManagedChannelBuilder.
                                    forAddress("localhost" , 6565).
                                    usePlaintext().build();
        SearchServiceGrpc.SearchServiceBlockingStub stub = SearchServiceGrpc.newBlockingStub(channel);
        SearchRequest request = SearchRequest.newBuilder().setQuery("There is a file to be read be full of kindness").build();
        SearchReply reply = stub.search(request);
        List<String> stringList = reply.getFilesList();
        for (String s: stringList)
        {
            System.out.println(s);
        }
    }
}
