/*
 * Decompiled with CFR 0.152.
 */
package org.AutoHealerAndClusterSearch.SearchWebApp.WebServer;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.Executors;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer
implements Watcher {
    static final Logger logger = LoggerFactory.getLogger(WebServer.class);
    private static final String TASK_ENDPOINT = "/search-query";
    private static final String COORDINATOR_ZNODE_PATH = "/coordinator_node";
    private final String zooKeeperServerAddress = "192.168.184.10";
    private static final int SESSION_TIMEOUT = 3000;
    private final int port;
    private HttpServer server;
    private ZooKeeper zooKeeper;
    private String CoordinatorAddress;
    private String Coordinator_Full_Name;

    public WebServer(int port) throws IOException, InterruptedException, KeeperException {
        this.port = port;
    }

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {
        int serverPort = 8080;
        if (args.length == 1) {
            serverPort = Integer.parseInt(args[0]);
        }
        WebServer webServer = new WebServer(serverPort);
        webServer.connectToZookeeper();
        webServer.startServer();
        System.out.println("Server is listening on port " + serverPort);
        logger.info("Server is listening on port " + serverPort);
        webServer.run();
        webServer.close();
    }

    public void connectToZookeeper() throws IOException, InterruptedException, KeeperException {
        this.zooKeeper = new ZooKeeper("192.168.184.10", 3000, (Watcher)this);
        this.setCoordinatorAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            this.zooKeeper.wait();
        }
    }

    private void close() throws InterruptedException {
        this.zooKeeper.close();
    }

    private synchronized void setCoordinatorAddress() throws InterruptedException, KeeperException {
        String cord = (String)this.zooKeeper.getChildren(COORDINATOR_ZNODE_PATH, (Watcher)this).get(0);
        this.Coordinator_Full_Name = "/coordinator_node/" + cord;
        Stat stat = this.zooKeeper.exists(this.Coordinator_Full_Name, false);
        if (stat == null) {
            logger.error("Coordinator Not Found");
            throw new RuntimeException();
        }
        this.CoordinatorAddress = new String(this.zooKeeper.getData(this.Coordinator_Full_Name, false, stat)).split("@")[1];
    }

    public void startServer() {
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            logger.info("Server Started at : " + System.nanoTime());
        }
        catch (IOException e) {
            logger.error("Server failed to Start at : " + System.nanoTime());
            throw new RuntimeException(e);
        }
        HttpContext taskContext = this.server.createContext(TASK_ENDPOINT);
        taskContext.setHandler(this::handleTaskRequest);
        this.server.setExecutor(Executors.newFixedThreadPool(8));
        this.server.start();
    }

    private void handleTaskRequest(HttpExchange exchange) throws IOException {
        logger.info("Query Request at " + System.nanoTime());
        if (!exchange.getRequestMethod().equalsIgnoreCase("post")) {
            exchange.close();
            return;
        }
        Headers headers = exchange.getRequestHeaders();
        long startTime = System.nanoTime();
        byte[] requestBytes = exchange.getRequestBody().readAllBytes();
        byte[] responseBytes = this.prepareRsponse(requestBytes);
        long finishTime = System.nanoTime();
        String debugMessage = String.format("Operation took %d ns", finishTime - startTime);
        exchange.getResponseHeaders().put("X-Debug-Info", Arrays.asList(debugMessage));
        this.sendResponse(responseBytes, exchange);
    }

    private byte[] prepareRsponse(byte[] requestBytes) {
        String bodyString = new String(requestBytes);
        String[] stringTerms = bodyString.split(" ");
        return String.format("Result of the multiplication is \n", new Object[0]).getBytes();
    }

    private void sendResponse(byte[] responseBytes, HttpExchange exchange) throws IOException {
        exchange.sendResponseHeaders(200, responseBytes.length);
        OutputStream outputStream = exchange.getResponseBody();
        outputStream.write(responseBytes);
        outputStream.flush();
        outputStream.close();
        exchange.close();
    }

    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case NodeChildrenChanged: {
                try {
                    logger.warn("Coordinator Changed !!");
                    this.setCoordinatorAddress();
                    break;
                }
                catch (InterruptedException | KeeperException e) {
                    logger.error("Could NOT Handle Node Children Changed Event!");
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

