/*
 * Decompiled with CFR 0.152.
 */
package org.AutoHealerAndClusterSearch.AutoHealerAndClusterSearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSorting {
    private static final Logger logger = LoggerFactory.getLogger(NodeSorting.class);

    public static List<String> sort(List<byte[]> workers, List<String> Nodes) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        logger.info("physical nodes are : " + Nodes);
        for (byte[] byArray : workers) {
            String string = new String(byArray);
            if (!Nodes.contains(string)) continue;
            int x = map.getOrDefault(string, 0);
            map.put(string, x + 1);
        }
        for (String string : Nodes) {
            int n = map.getOrDefault(string, 0);
            map.put(string, n);
        }
        ArrayList<Pair> temp = new ArrayList<Pair>();
        for (Map.Entry entry : map.entrySet()) {
            Pair pair = new Pair((String)entry.getKey(), (Integer)entry.getValue());
            temp.add(pair);
        }
        Comparator<Pair> comparator = new Comparator<Pair>(){

            @Override
            public int compare(Pair p1, Pair p2) {
                return p1.tasksNo - p2.tasksNo;
            }
        };
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.sort(temp, comparator);
        for (Pair pair : temp) {
            arrayList.add(pair.node);
        }
        return arrayList;
    }

    private static class Pair {
        String node;
        int tasksNo;

        public Pair(String x, int y) {
            this.node = x;
            this.tasksNo = y;
        }

        public String toString() {
            return "node : " + this.node + " has : " + this.tasksNo + " workers !!";
        }
    }
}

