/*
 * Decompiled with CFR 0.152.
 */
package org.AutoHealerAndClusterSearch.WordsCountingInFiles;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.AutoHealerAndClusterSearch.ObjectExchangeInCluster.FileWordPair;

public class WordsCountingInFiles {
    public static Map<String, List<FileWordPair>> countWordsInFiles(List<String> words, List<String> filePaths) {
        HashMap<String, List<FileWordPair>> wordOccurrences = new HashMap<String, List<FileWordPair>>();
        for (String filePath : filePaths) {
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
                String line;
                StringBuilder textBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    textBuilder.append(line).append("\n");
                }
                String text = textBuilder.toString();
                int size = text.length();
                size = Math.max(size, 1);
                for (String word : words) {
                    int count = WordsCountingInFiles.countWordOccurrencesInText(word, text);
                    if (count == 0) continue;
                    double freq = 1.0 * (double)count / (double)size;
                    List FileWordPair2 = wordOccurrences.getOrDefault(word, new ArrayList());
                    FileWordPair2.add(new FileWordPair(filePath, freq));
                    wordOccurrences.put(word, FileWordPair2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wordOccurrences;
    }

    public static Map<String, List<FileWordPair>> countWordsInFiles(String query, List<String> filePaths) {
        String[] temp = query.split(" ");
        ArrayList<String> words = new ArrayList<String>();
        for (String s : temp) {
            words.add(s);
        }
        return WordsCountingInFiles.countWordsInFiles(words, filePaths);
    }

    public static int countWordOccurrencesInText(String word, String text) {
        int count = 0;
        int index = text.toLowerCase().indexOf(word.toLowerCase());
        while (index != -1) {
            ++count;
            index = text.toLowerCase().indexOf(word.toLowerCase(), index + 1);
        }
        return count;
    }
}

