/*
 * Decompiled with CFR 0.152.
 */
package org.AutoHealerAndClusterSearch.AutoHealerAndClusterSearch;

import java.io.IOException;
import org.AutoHealerAndClusterSearch.AutoHealerAndClusterSearch.OnElectionCallback;
import org.AutoHealerAndClusterSearch.AutoHealerAndClusterSearch.ServiceRegistry;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnElectionAction
implements OnElectionCallback {
    private final Logger logger = LoggerFactory.getLogger(OnElectionAction.class);
    private final ServiceRegistry serviceRegistry;
    private final int port;

    public OnElectionAction(ServiceRegistry serviceRegistry, int port) {
        this.serviceRegistry = serviceRegistry;
        this.port = port;
    }

    @Override
    public void onElectedToBeLeader(String IP) {
        this.serviceRegistry.unregisterFromCluster();
        this.serviceRegistry.registerForUpdates();
        try {
            this.serviceRegistry.registerToCoordinator(IP);
        }
        catch (IOException | InterruptedException | KeeperException e) {
            this.logger.error("Could Not Register to be Coordinator");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onWorker(String IP) {
        try {
            this.serviceRegistry.registerToCluster(IP);
        }
        catch (IOException | InterruptedException | KeeperException e) {
            this.logger.error("Could Not Register To Cluster");
            e.printStackTrace();
        }
    }
}

