/*
 * Decompiled with CFR 0.152.
 */
package org.AutoHealerAndClusterSearch.AutoHealerAndClusterSearch;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.AutoHealerAndClusterSearch.ObjectExchangeInCluster.FileWordPair;
import org.AutoHealerAndClusterSearch.ObjectExchangeInCluster.SearchQueryRequest;
import org.AutoHealerAndClusterSearch.ObjectExchangeInCluster.SearchQueryResponse;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coordinator {
    private ZooKeeper zooKeeper;
    private static final String PHYSICAL_ZNODES_PATH = "/physical_nodes";
    private int COORDINATOR_PORT;
    private String FILES_DIRECTORY = "";
    private final Logger logger = LoggerFactory.getLogger(Coordinator.class);

    public Coordinator(ZooKeeper zooKeeper, String SOCKET) {
        this.zooKeeper = zooKeeper;
        this.COORDINATOR_PORT = Integer.parseInt(SOCKET.split(":")[1]);
        this.FILES_DIRECTORY = System.getProperty("user.dir") + "/SearchFiles/";
    }

    public void start() throws IOException, InterruptedException, KeeperException {
        System.out.println("Server started on port " + this.COORDINATOR_PORT);
        this.logger.info("Server started on port " + this.COORDINATOR_PORT);
        while (true) {
            Scanner scanner = new Scanner(System.in);
            System.out.println("Enter Query To Search : ");
            String query = scanner.nextLine();
            System.out.println("Query = " + query);
            Thread clientThread = new Thread(() -> this.handleClient(query));
            clientThread.start();
        }
    }

    private SearchQueryResponse sendRequestToNode(SearchQueryRequest searchQueryRequest, String ipAddress) {
        SearchQueryResponse searchQueryResponse = null;
        String ip = ipAddress.split(":")[0];
        int port = Integer.parseInt(ipAddress.split(":")[1]);
        try (Socket socket = new Socket(ip, port);){
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(searchQueryRequest);
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            searchQueryResponse = (SearchQueryResponse)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return searchQueryResponse;
    }

    private void sendResponsesToClient(List<String> filesAnswer) {
        if (filesAnswer.size() == 0) {
            System.out.println("No Matches Found !!!");
            return;
        }
        for (String file : filesAnswer) {
            System.out.println(file);
        }
    }

    private void handleClient(String query) {
        try {
            List<SearchQueryResponse> respons = this.spreadQuery(query);
            if (respons == null) {
                System.out.println("No Nodes Are Working , Search Cannot Be Done");
                this.logger.warn("No Nodes Are Working , Search Cannot Be Done");
            }
            Map<String, Double> filesScore = this.getFilesScore(respons, query);
            List<String> answer = this.getFilesInOrder(filesScore);
            this.sendResponsesToClient(answer);
        }
        catch (IOException | InterruptedException | KeeperException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Double> getFilesScore(List<SearchQueryResponse> respons, String query) {
        String[] words;
        if (respons == null) {
            return null;
        }
        if (query.isEmpty()) {
            return null;
        }
        Map<String, Double> wordsIDF = this.calculateIDF(respons, query);
        HashMap<String, Double> fileScore = new HashMap<String, Double>();
        for (String word : words = query.split(" ")) {
            for (SearchQueryResponse response : respons) {
                Map<String, Double> temp = response.calcScoreForFilesContainingWord(word, wordsIDF.get(word));
                for (Map.Entry<String, Double> x : temp.entrySet()) {
                    fileScore.put(x.getKey(), fileScore.getOrDefault(x.getKey(), 0.0) + x.getValue());
                }
            }
        }
        return fileScore;
    }

    private List<String> getFilesInOrder(Map<String, Double> filesScore) {
        ArrayList<String> files = new ArrayList<String>();
        if (filesScore == null) {
            files.add("No Answer !");
            return files;
        }
        ArrayList<Map.Entry<String, Double>> entryList = new ArrayList<Map.Entry<String, Double>>(filesScore.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> entry1, Map.Entry<String, Double> entry2) {
                return entry2.getValue().compareTo(entry1.getValue());
            }
        });
        for (Map.Entry entry : entryList) {
            files.add((String)entry.getKey());
        }
        return files;
    }

    private Map<String, Double> calculateIDF(List<SearchQueryResponse> respons, String query) {
        String[] words;
        HashMap<String, Double> wordsIDF = new HashMap<String, Double>();
        int totalNumberOfFiles = this.countFilesInDirectory();
        for (String word : words = query.split(" ")) {
            int wordFreq = 0;
            for (SearchQueryResponse slaveAns : respons) {
                Map<String, List<FileWordPair>> temp = slaveAns.getWordFrequencies();
                wordFreq += ((List)temp.getOrDefault(word, new ArrayList())).size();
            }
            Double d = wordFreq > 0 ? Math.log(1.0 * (double)totalNumberOfFiles / (double)wordFreq) : 0.0;
            wordsIDF.put(word, d);
        }
        return wordsIDF;
    }

    private int countFilesInDirectory() {
        int n;
        block8: {
            Stream<Path> files = Files.list(Paths.get(this.FILES_DIRECTORY, new String[0]));
            try {
                n = (int)files.count();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            files.close();
        }
        return n;
    }

    public List<SearchQueryResponse> spreadQuery(String query) throws InterruptedException, KeeperException, IOException, ExecutionException {
        List physicalZnodes = this.zooKeeper.getChildren(PHYSICAL_ZNODES_PATH, false);
        if (physicalZnodes.isEmpty()) {
            return null;
        }
        int totalFilesNumber = this.countFilesInDirectory();
        int filesNumberforNode = (totalFilesNumber + physicalZnodes.size() - 1) / physicalZnodes.size();
        int remaining = totalFilesNumber;
        int index = 0;
        int filesOffset = 0;
        ExecutorService executorService = Executors.newFixedThreadPool(physicalZnodes.size());
        ArrayList<Callable<SearchQueryResponse>> tasks = new ArrayList<Callable<SearchQueryResponse>>();
        while (remaining > 0) {
            String physicalZnode = (String)physicalZnodes.get(index);
            Stat stat = this.zooKeeper.exists("/physical_nodes/" + (String)physicalZnodes.get(index), false);
            if (stat == null) {
                this.logger.warn("Physical Node : " + physicalZnode + " is dowm!");
                physicalZnodes.remove(index);
                filesNumberforNode = (totalFilesNumber + physicalZnodes.size() - 1) / physicalZnodes.size();
                continue;
            }
            String ipAddress = new String(this.zooKeeper.getData("/physical_nodes/" + (String)physicalZnodes.get(index), false, stat));
            SearchQueryRequest searchQueryRequest = new SearchQueryRequest(query, filesNumberforNode, filesOffset);
            tasks.add(() -> this.sendRequestToNode(searchQueryRequest, ipAddress));
            index = (1 + index) % physicalZnodes.size();
            filesOffset = (filesOffset + filesNumberforNode) % totalFilesNumber;
            remaining -= filesNumberforNode;
        }
        List futures = executorService.invokeAll(tasks);
        ArrayList<SearchQueryResponse> respons = new ArrayList<SearchQueryResponse>();
        for (int i = 0; i < futures.size(); ++i) {
            SearchQueryResponse searchQueryResponse = (SearchQueryResponse)futures.get(i).get();
            respons.add(searchQueryResponse);
        }
        executorService.shutdown();
        return respons;
    }
}

