/*
 * Decompiled with CFR 0.152.
 */
package org.AutoHealerAndClusterSearch.AutoHealerAndClusterSearch;

import java.io.IOException;
import java.util.Scanner;
import org.AutoHealerAndClusterSearch.AutoHealerAndClusterSearch.LeaderElection;
import org.AutoHealerAndClusterSearch.AutoHealerAndClusterSearch.OnElectionAction;
import org.AutoHealerAndClusterSearch.AutoHealerAndClusterSearch.ServiceRegistry;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application
implements Watcher {
    private static final String address = "192.168.184.10:2181";
    private static final int SESSION_TIMEOUT = 3000;
    private static final int DEFAULT_PORT = 54321;
    private ZooKeeper zooKeeper;
    private final Logger logger = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) throws IOException, InterruptedException, KeeperException {
        Scanner scanner = new Scanner(System.in);
        System.out.println("Enter Port !!");
        String IP = "127.0.0.1";
        int port = scanner.nextInt();
        System.out.println("IP is : " + IP);
        System.out.println("Port is : " + port);
        Application application = new Application();
        ZooKeeper zooKeeper = application.connectToZookeeper();
        ServiceRegistry serviceRegistry = new ServiceRegistry(zooKeeper);
        OnElectionAction onElectionAction = new OnElectionAction(serviceRegistry, port);
        LeaderElection leaderElection = new LeaderElection(zooKeeper, onElectionAction);
        leaderElection.volunteerForLeadership(IP + ":" + port);
        leaderElection.reelectLeader();
        application.run();
        application.close();
    }

    public ZooKeeper connectToZookeeper() throws IOException {
        this.zooKeeper = new ZooKeeper(address, 3000, (Watcher)this);
        return this.zooKeeper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        ZooKeeper zooKeeper = this.zooKeeper;
        synchronized (zooKeeper) {
            this.zooKeeper.wait();
        }
    }

    private void close() throws InterruptedException {
        this.zooKeeper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent watchedEvent) {
        switch (watchedEvent.getType()) {
            case None: {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    this.logger.info("Successfully connected to Zookeeper");
                    break;
                }
                if (watchedEvent.getState() == Watcher.Event.KeeperState.Disconnected) {
                    ZooKeeper zooKeeper = this.zooKeeper;
                    synchronized (zooKeeper) {
                        this.logger.warn("Disconnected from Zookeeper");
                        this.zooKeeper.notifyAll();
                        break;
                    }
                }
                if (watchedEvent.getState() != Watcher.Event.KeeperState.Closed) break;
                this.logger.info("Closed Successfully");
            }
        }
    }
}

