package org.AutoHealerAndClusterSearch.testTransmitting;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class Receiver {
    public static void main(String[] args) {
        int serverPort = 12345;

        try {
            // Create a ServerSocket and bind it to the specified port
            ServerSocket serverSocket = new ServerSocket(serverPort);

            System.out.println("Waiting for incoming connections...");

            // Accept a client connection
            Socket socket = serverSocket.accept();

            System.out.println("Connection established with a client.");

            // Get the InputStream from the socket
            InputStream inputStream = socket.getInputStream();

            // Create an ObjectInputStream to deserialize the object
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);

            // Read the serialized object and cast it back to the original object type
            MyClass receivedObj = (MyClass) objectInputStream.readObject();

            // Close the input stream, object input stream, and socket
            objectInputStream.close();
            inputStream.close();
            socket.close();

            System.out.println("Object received successfully : " + receivedObj.sth);
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}