/*
 * Decompiled with CFR 0.152.
 */
package org.example;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class DistributedGrep {

    public static class GrepReducer
    extends Reducer<Text, Text, Text, Text> {
        protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)new Text());
        }
    }

    public static class GrepMapper
    extends Mapper<LongWritable, Text, Text, Text> {
        private Text outputKey = new Text();
        private Text outputValue = new Text();
        private String pattern;

        public static void main(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
            if (args.length != 3) {
                System.err.println("Usage: DistributedGrep.jar <input_path> <output_path> <pattern>");
                System.exit(1);
            }
            String inputPath = args[0];
            String outputPath = args[1];
            String pattern = args[2];
            Configuration conf = new Configuration();
            Job job = Job.getInstance((Configuration)conf, (String)"Distributed-Grep");
            job.setJarByClass(DistributedGrep.class);
            job.setMapperClass(GrepMapper.class);
            job.setReducerClass(GrepReducer.class);
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Text.class);
            FileInputFormat.addInputPath((Job)job, (Path)new Path(inputPath));
            FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
            System.exit(job.waitForCompletion(true) ? 0 : 1);
        }

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String line = value.toString();
            if (line.contains(this.pattern)) {
                this.outputKey.set(line);
                this.outputValue.set("");
                context.write((Object)this.outputKey, (Object)this.outputValue);
            }
        }
    }
}

