package org.example;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

import java.io.IOException;

public class DistributedGrep
{

    public static class GrepMapper extends Mapper<LongWritable, Text, Text, Text>
    {
        private Text outputKey = new Text();
        private Text outputValue = new Text();
        private String pattern;

        public static void main(String[] args) throws IOException, ClassNotFoundException, InterruptedException
        {
            if (args.length != 3)
            {
                System.err.println("Usage: DistributedGrep.jar <input_path> <output_path> <pattern>");
                System.exit(1);
            }

            String inputPath = args[0];
            String outputPath = args[1];
            String pattern = args[2];

            Configuration conf = new Configuration();

            Job job = Job.getInstance(conf, "Distributed-Grep");
            job.setJarByClass(DistributedGrep.class);

            job.setMapperClass(GrepMapper.class);
            job.setReducerClass(GrepReducer.class);

            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(Text.class);

            FileInputFormat.addInputPath(job, new Path(inputPath));
            FileOutputFormat.setOutputPath(job, new Path(outputPath));


            System.exit(job.waitForCompletion(true) ? 0 : 1);
        }


        @Override
        protected void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException
        {
            String line = value.toString();
            if (line.contains(pattern))
            {
                outputKey.set(line);
                outputValue.set("");
                context.write(outputKey, outputValue);
            }
        }
    }

    public static class GrepReducer extends Reducer<Text, Text, Text, Text>
    {
        @Override
        protected void reduce(Text key, Iterable<Text> values, Context context) throws IOException, InterruptedException {
            context.write(key, new Text());
        }
    }

}