package main

import (
	"context"
	"fmt"
	"log"
	"net"

	pb "calc/calculator"
	"google.golang.org/grpc"
)

type CalculatorServer struct {
	pb.UnimplementedCalculatorServer
}

func (s *CalculatorServer) CalculateNumbers(ctx context.Context, req *pb.Request) (*pb.Response, error) {
	fmt.Printf("Received numbers: %d, %d\n", req.Number1, req.Number2)
	return &pb.Response{
		Number1: req.Number1,
		Number2: req.Number2,
	}, nil
}

type ForwardServer struct {
	pb.UnimplementedForwardServer
}

func (s *ForwardServer) ForwardNumbers(ctx context.Context, req *pb.Request) (*pb.Response, error) {
	fmt.Printf("Received numbers: %d, %d\n", req.Number1, req.Number2)

	conn, err := grpc.Dial("192.168.184.11:50052", grpc.WithInsecure())
	if err != nil {
		log.Fatalf("Failed to connect to Calculator: %v", err)
	}
	defer conn.Close()

	client := pb.NewCalculatorClient(conn)
	calculateReq := &pb.Request{
		Number1: (req.Number1),
		Number2: (req.Number2),
	}

	calculateRes, err := client.CalculateNumbers(context.Background(), calculateReq)
	if err != nil {
		log.Fatalf("CalculateNumbers RPC failed: %v", err)
	}

	return &pb.Response{
		Number1: calculateRes.Number1,
		Number2: calculateRes.Number2,
	}, nil
}

func main() {
	fmt.Println("BFDBFDBDB")
	listenAddr := "localhost:50051" // Address to listen for gRPC requests

	lis, err := net.Listen("tcp", listenAddr)
	if err != nil {
		log.Fatalf("Failed to listen: %v", err)
	}

	fmt.Println("Go Forwarder server listening on", listenAddr)

	s := grpc.NewServer()
	pb.RegisterCalculatorServer(s, &CalculatorServer{})
	pb.RegisterForwardServer(s, &ForwardServer{})

	if err := s.Serve(lis); err != nil {
		log.Fatalf("Failed to serve: %v", err)
	}
}
