package org.example;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public class Bot extends TelegramLongPollingBot {


//    https://core.telegram.org/bots/tutorial
    @Override
    public String getBotUsername() {
        return "Put your Telegram Username here";
    }

    @Override
    public String getBotToken() {
        return "Put your Telegram Token here ";
    }

    private String prompts;
    @Override
    public void onUpdateReceived(Update update) {
        var msg = update.getMessage();
        var user = msg.getFrom();
        var id = user.getId();

        llama3 l3 = new llama3();
        prompts = msg.getText();
        String resp = l3.llmChat(msg.getText());
        sendText(id,resp + " \n \uD83D\uDC50\uD83C\uDFFB back at ya! \uD83D\uDE0A");

        System.out.println(user.getFirstName() + " wrote " + msg.getText());
    }

    public void sendText(Long who, String what){
        SendMessage sm = SendMessage.builder()
                .chatId(who.toString()) //Who are we sending a message to
                .text(what).build();    //Message content
        try {
            execute(sm);                        //Actually sending the message
        } catch (TelegramApiException e) {
            throw new RuntimeException(e);      //Any error will be printed here
        }
    }


}