package org.example;

import io.github.amithkoujalgi.ollama4j.core.exceptions.OllamaBaseException;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

import java.io.IOException;

public class Bot extends TelegramLongPollingBot {


    //    https://core.telegram.org/bots/tutorial

//    https://amithkoujalgi.github.io/ollama4j/docs/intro
    private String prompt;


    @Override
//    public String getBotUsername() {
//        return "Put your Telegram Username here";
//    }
    public String getBotUsername() {
        return "Put your Telegram Username here";
    }

    @Override
//    public String getBotToken() {
//        return "Put your Telegram Token here";
//    }
    public String getBotToken() {
        return "Put your Telegram Token here";
    }

    @Override
    public void onUpdateReceived(Update update) {
        var msg = update.getMessage();
        var user = msg.getFrom();
        var id = user.getId();

        prompt = msg.getText();

        System.out.println(user.getFirstName() + " wrote " + prompt);

//        String pre_response = "Please Wait for Response ..." + "\n \uD83D\uDC50\uD83C\uDFFB";
//        sendText(id, pre_response);

        try {
            String response = Ollama.getResponse(prompt);
            sendText(id, response);
        } catch (OllamaBaseException e) {
            sendText(id, " \n \uD83D\uDC50\uD83C\uDFFB please try again later! \uD83D\uDE0A");
            throw new RuntimeException(e);
        } catch (IOException e) {
            sendText(id, " \n \uD83D\uDC50\uD83C\uDFFB please try again later! \uD83D\uDE0A");
            throw new RuntimeException(e);
        } catch (InterruptedException e) {
            sendText(id, " \n \uD83D\uDC50\uD83C\uDFFB please try again later! \uD83D\uDE0A");
            throw new RuntimeException(e);
        }
    }

    public void sendText(Long who, String what) {
        SendMessage sm = SendMessage.builder()
                .chatId(who.toString()) //Who are we sending a message to
                .text(what).build();    //Message content
        try {
            execute(sm);                        //Actually sending the message
        } catch (TelegramApiException e) {
            throw new RuntimeException(e);      //Any error will be printed here
        }
    }


}