# TeleLlama3 Bot: A Question-Answering Telegram Bot using Java
 
This project creates a Telegram bot that utilizes a large language model (LLM) to answer your questions. You can interact with the bot by sending questions directly in Telegram.


### Features
* Answer your questions using a powerful LLM (currently using LLAMA 3 as an example).
* Interact with the bot directly in Telegram.

### Prerequisites
* Java development environment (e.g., IntelliJ IDEA, NetBeans)
* Telegram account

### Installation
1. Create a Telegram Bot
   * Visit [From BotFather to 'Hello World'](https://core.telegram.org/bots/tutorial) on Telegram and create a new bot.
   * You'll receive a bot token. Store this securely (e.g., environment variables)
2. [Deploy local llama3](https://ollama.com/download) 
3. [Use Java library (wrapper/binding) for Ollama server.](https://github.com/amithkoujalgi/ollama4j/tree/main)


### Configuration
1. Replace placeholders:
   * In the ``Bot.java`` file, replace *YourBotUsername* with your desired bot username.
   * Update the *botToken* variable with your actual Telegram bot token obtained from BotFather.

### Try it now 
[Try it now on Telegram !!](https://t.me/analyticshiast_bot)

### Contributing
Feel free to fork this repository and make modifications. Pull requests are welcome!