package org.ds.grpc.server;

import org.ds.StudentRequest;
import org.ds.StudentResponse;
import org.ds.StudentServiceGrpc;
import io.grpc.stub.StreamObserver;
import org.lognet.springboot.grpc.GRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


@GRpcService
public class gServer extends StudentServiceGrpc.StudentServiceImplBase {


    Logger logger = LoggerFactory.getLogger(gServer.class);

    public void getStudent(StudentRequest request,
                           StreamObserver<StudentResponse> responseObserver) {
        var id = request.getId();
        logger.info("req:" + id);

        StudentResponse studentResponse;
        if (id == 1) {
            studentResponse = StudentResponse.newBuilder().setAge("30").setName("Student").build();
        } else {
            studentResponse = StudentResponse.newBuilder().setName("404").build();
        }
        responseObserver.onNext(studentResponse);
//        responseObserver.onError(new Exception("error"));
        responseObserver.onCompleted();


    }

    public void serverSideStreaming(StudentRequest req, StreamObserver<StudentResponse> responseStreamObserver) {

        var id = req.getId();
        logger.info("req:" + id);

        StudentResponse studentResponse;
        for (int i = 0; i < 10; i++) {
            if (id == 1) {
                studentResponse = StudentResponse.newBuilder().setAge("30").setName("Student").build();
            } else {
                studentResponse = StudentResponse.newBuilder().setName("404").build();
            }
            responseStreamObserver.onNext(studentResponse);
        }

//        responseObserver.onError(new Exception("error"));
        responseStreamObserver.onCompleted();
    }

}
