
# Multi-Service Web Application with HAProxy

This project sets up a multi-service web application environment using Docker Compose. It includes three instances of a web application (app1, app2, app3) and an HAProxy load balancer to distribute traffic among them.

## Project Structure

```
.
├── docker-compose.yml
├── haproxy
│   ├── Dockerfile
│   └── haproxy.cfg
└── webapp
├── Dockerfile
└── ... (other web application files)
```

## Services

- **app1**: First instance of the web application, configured to listen on port 9001.
- **app2**: Second instance of the web application, configured to listen on port 9002.
- **app3**: Third instance of the web application, configured to listen on port 9003.
- **haproxy**: HAProxy load balancer that distributes incoming traffic to app1, app2, and app3.

## Prerequisites

Before running this project, ensure you have Docker and Docker Compose installed on your machine. You can download them from the [official Docker website](https://www.docker.com/get-started).

## Building and Running the Services

1. **Navigate to the project directory**:
   ```sh
   cd /path/to/your/project
   ```

2. **Build the Docker images**:
   ```sh
   docker-compose build
   ```

3. **Start the services**:
   ```sh
   docker-compose up -d
   ```

4. **Verify the services are running**:
   ```sh
   docker-compose ps
   ```

## Configuring HAProxy

The HAProxy configuration file (`haproxy.cfg`) is located in the `haproxy` directory. This file defines how traffic is distributed among the web application instances. You can modify this file to change the load balancing behavior or add more backend servers.

Example configuration snippet:
```cfg
global
    maxconn 500

defaults
    mode http
    timeout connect 10s
    timeout client  50s
    timeout server  50s

frontend http-in
    bind *:80
    default_backend application_nodes

backend application_nodes
    balance roundrobin
    option httpchk GET /status
    http-check expect string "Server is alive"
    server server01 app1:9001 check inter 1s
    server server02 app2:9002 check inter 2s
    server server03 app3:9003 check inter 2s

listen stats 
    bind *:83
    stats enable
    stats uri /
```

## Accessing the Services

- **Web Application**: You can access the web application directly by navigating to `http://localhost:9001`, `http://localhost:9002`, or `http://localhost:9003`.
- **HAProxy**: The HAProxy load balancer will be accessible at `http://localhost`.

## Stopping the Services

To stop the services, run:
```sh
docker-compose down
```
