package org.multithreading;

import java.util.ArrayList;
import java.util.List;

public class Main {

    public static void main(String[] args) {

        List<StudentServiceThread> studentServiceThreadList = new ArrayList<>();

        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 10; i++) {
            Student student = new Student("test " + i);
//            System.out.println("Current Thread: "+Thread.currentThread().getName());

            StudentService studentService = new StudentService();
            StudentServiceThread studentServiceThread = new StudentServiceThread(student, studentService);
            studentServiceThread.start();
            studentServiceThreadList.add(studentServiceThread);
        }

        for (StudentServiceThread studentServiceThread : studentServiceThreadList) {
            try {
                studentServiceThread.join();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

//        for (int i = 0; i < 10; i++) {
//
//            studentService.saveStudent(student);
//        }
        long duration = System.currentTimeMillis() - startTime;
        System.out.println("Time Taken: " + duration);

    }
}