#include <stdio.h>
#include <omp.h>


//simple example to demonstrate race condition in parallel programs and barrier
void start()
{
    int x = 2;

    omp_lock_t lock;
    omp_init_lock(&lock);

    #pragma omp parallel num_threads(6)
    {
        int threadId = omp_get_thread_num();

        if (threadId == 0)
            x = 5;
        else
            printf("I am Thread %d and for me x=%d \n", threadId, x);


        #pragma omp barrier 
        {
            omp_set_lock(&lock);
                printf("\n\nAfter lock => I am Thread %d\n", threadId);
                printf("I am same thread %d\n", threadId);
            omp_unset_lock(&lock);
        }
        

        omp_destroy_lock(&lock);
    }
}

void main(int count, char *arg[])
{
    start();
}