#include <omp.h>
#include <stdio.h>

void main(int count, char *arg[])
{
    int flag = 0;
    #pragma omp parallel num_threads(3)
    {
        int threadId = omp_get_thread_num();

        if (threadId == 0)
        {
        /* Set flag to release thread 1 */
        #pragma omp atomic update
            flag++;
            /* Flush of flag is implied by the atomic directive */
        }
        else if (threadId == 1)
        {
        /* Loop until we see that flag reaches 1*/
        #pragma omp flush(flag)
            while (flag < 1)
            {
                #pragma omp flush(flag)
            }
            printf("Thread 1 awoken\n");
        /* Set flag to release thread 2 */
        #pragma omp atomic update
            flag++;
            /* Flush of flag is implied by the atomic directive */
        }
        else if (threadId == 2)
        {
        /* Loop until we see that flag reaches 2 */
        #pragma omp flush(flag)
            while (flag < 2)
            {
                #pragma omp flush(flag)
            }
            printf("Thread 2 awoken\n");
        }
    }
}