#include <stdio.h>
#include <omp.h>


//simple example to demonstrate race condition in parallel programs and barrier
void start()
{
    int x = 2;
    #pragma omp parallel num_threads(6)
    {
        int threadId = omp_get_thread_num();

        if (threadId == 0)
            x = 5;
        else
            printf("I am Thread %d and for me x=%d \n", threadId, x);

        #pragma omp barrier
        {
            #pragma ordered
                printf("After Barrier => I am Thread %d and for me x=%d \n", threadId, x);

            #pragma ordered
                printf("After Order => I am Thread %d and for me x=%d \n", threadId, x);
        }
        
    }
}

void main(int count, char *arg[])
{
    start();
}