#include <stdio.h>
#include <omp.h>


//simple example to demonstrate race condition in parallel programs and barrier
void start()
{
    #pragma omp parallel num_threads(12)
    {
        int threadId = omp_get_thread_num();

    int i=0, length = 10;
    int array[length];
    for(i = 0; i < length; i++)
            array[i] = i;

    int index = 0;
    double sum = 0.0, avg = 0.0;

    #pragma omp parallel for reduction (+:sum)
    for(index = 0; index < length; index++)
            sum += array[index];

    //calculate average
    #pragma omp barrier
    #pragma omp single
        {
            avg = sum/(double)length;
            printf("Average is avg = %f\n", avg);
        }
        
    }
}

void main(int count, char *arg[])
{
    start();
}