#include "omp.h"
#include "stdlib.h"
#include "stdio.h"

void simpleParalleloop(int n, float *a, float *b, float *res)
{
    int index;
#pragma omp parallel for num_threads(4)
    for (index = 1; index < n; index++) /* index is private by default */
    {
        res[index] = (a[index] + b[index]);
    }
}

void main(int count, char *arg[])
{

    int n = count > 1 ? atoi(arg[1]) : 10;
    float a[n], b[n], res[n];

    //set array a values
    for (int i = 0; i < n; i++)
    {
        a[i] = i * i;
        b[i] = i;
    }

    simpleParalleloop(n, a, b, res);

    printf("\nThe Result Is: \r\n");
    for (int i = 0; i < n; i++)
        printf("%f, ", res[i]);

    printf("\n");
}