#include "omp.h"
#include "stdlib.h"
#include "stdio.h"


//simple hello world parallel method
void startParallelHeloworld()
{
    int x=0;
#pragma omp parallel num_threads(8)
    {
        
        int id = omp_get_thread_num();
        //printf("Number of thread = %d\n", id);

        if (id == 0)
           printf("Hello From Master: => Threads Count is: %d \n", omp_get_num_threads());
        else
            printf("Hello from Thread %d\n", id);
        for(int i=0;i<10000;i++){
            x++;
        }
    }
    printf("Done x=%d\n",x);
}

//SPMD
void forExample(){
    int i, k, N=20;
    double A[N], B[N], C[N];
    #pragma omp parallel for
        for (i=0; i<N; i++) {
            int id = omp_get_thread_num();
            A[i] = B[i] + k*C[i];
            printf("\t %d Tid: %d\n",i,id);
        }
}


//Main method
int main(int count, char *arg[])
{
    int nthreads;
    nthreads = omp_get_num_threads();
    //printf("Main Number of threads = %d\n", nthreads);
    startParallelHeloworld();
    printf("level1\n");
    forExample();
    printf("level2\n");
    //sleep(1);
    return 0;
}
