#include <omp.h>
#include <stdio.h>
#include <stdlib.h>

static long steps = 1000000000;
double step;

int main (int argc, const char *argv[]) {

    int i,j;
    double x;
    double pi, sum = 0.0;
    double start, delta;

    step = 1.0/(double) steps;

	sum = 0.0;


	#pragma omp parallel for reduction(+:sum) private(x)
	for (i=0; i < steps; i++) {
		x = (i+0.5)*step;
		sum += 4.0 / (1.0+x*x); 
	}

	// Out of the parallel region, finialize computation
	pi = step * sum;
	printf("PI = %.16g\n", pi);
		
}