#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char** argv) {
  const int PING_PONG_LIMIT = 10;

  // Initialize the MPI environment
  MPI_Init(NULL, NULL);
  // Find out rank, size
  int world_rank;
  MPI_Comm_rank(MPI_COMM_WORLD, &world_rank);
  int world_size;
  MPI_Comm_size(MPI_COMM_WORLD, &world_size);

  // We are assuming 2 processes for this task
  if (world_size != 2) {
    fprintf(stderr, "World size must be two for %s\n", argv[0]);
    MPI_Abort(MPI_COMM_WORLD, 1);
  }

int ping_pong_count = 0;
while (ping_pong_count < PING_PONG_LIMIT)
{
    if (world_rank == 0)
    {
        ping_pong_count++;
        MPI_Send(&ping_pong_count, 1, MPI_INT, 1, 0, MPI_COMM_WORLD);
        printf("%d sent and incremented ping_pong_count %d to %d\n",
             world_rank, ping_pong_count, 1);
        MPI_Recv(&ping_pong_count, 1, MPI_INT, 1, 0, MPI_COMM_WORLD,
               MPI_STATUS_IGNORE);
        printf("%d received ping_pong_count %d from %d\n",
             world_rank, ping_pong_count, 1);

    }else
    {
        MPI_Recv(&ping_pong_count, 1, MPI_INT, 0, 0, MPI_COMM_WORLD,
               MPI_STATUS_IGNORE);
        printf("%d received ping_pong_count %d from %d\n",
             world_rank, ping_pong_count, 0);
         ping_pong_count++;
        MPI_Send(&ping_pong_count, 1, MPI_INT, 0, 0, MPI_COMM_WORLD);
        printf("%d sent and incremented ping_pong_count %d to %d\n",
             world_rank, ping_pong_count, 0);
        
    }
    
    
}

  MPI_Finalize();
}