package ParkingCash;

import java.util.concurrent.*;

public class Main {
    public static void main(String[] args) throws InterruptedException {

        ParkingCash cash = new ParkingCash();
        ParkingStats stats = new ParkingStats(cash);
        System.out.printf("Parking Simulator\n");

        int numberSensors = 2 * Runtime.getRuntime().availableProcessors();
        System.out.println("Num of Sensors " + numberSensors);

        ExecutorService executorService = Executors.newFixedThreadPool(numberSensors);
        long start = System.currentTimeMillis();
        for (int i = 0; i < numberSensors; i++) {
            executorService.submit(new Sensor(stats));
        }
        executorService.shutdown();
        executorService.awaitTermination(3, TimeUnit.SECONDS);
        long end = System.currentTimeMillis() - start;

        System.out.printf("Number of cars: %d\n",
                stats.getNumberCars());
        System.out.printf("Number of motorcycles: %d\n",
                stats.getNumberMotorcycles());
        cash.close();
        System.out.println();
        System.out.println("Time Execution: "+ end);

    }
}
