/*
In a Java program's `main` method, you typically don't need to use `join()` because the Java Virtual Machine (JVM) will not exit until all non-daemon threads have finished execution¹.
This means that even if the `main` method finishes, the JVM will still wait for all spawned threads to complete before it exits¹.

However, in a JUnit test, the situation is different. The JUnit framework itself is running in the main thread, and it executes each test method (each marked with `@Test`) in turn¹. If a test method spawns a new thread and then returns, JUnit will consider that test method as finished and proceed to the next test¹.
It won't wait for the spawned thread to finish¹. This can lead to unpredictable and incorrect results, because the test might finish before the thread has completed its work¹.

Therefore, in a JUnit test, if you spawn a thread and you want to wait for that thread to finish before proceeding
(for example, to check the results of the thread's work), you would use `join()`¹.
 This causes the current thread (the main JUnit thread) to pause and wait for the spawned thread to finish¹.

Source: Conversation with Bing, 11/15/2023
(1) java - Why can classes being unit tested with JUnit not have a main .... https://stackoverflow.com/questions/4365883/why-can-classes-being-unit-tested-with-junit-not-have-a-main.
(2) java junit has no main function - Stack Overflow. https://stackoverflow.com/questions/14011981/java-junit-has-no-main-function.
(3) java - Testing main method by junit - Stack Overflow. https://stackoverflow.com/questions/36349827/testing-main-method-by-junit.
(4) How do you unit test main method in Java? - Stack Overflow. https://stackoverflow.com/questions/59855313/how-do-you-unit-test-main-method-in-java.*/

import junit.framework.TestCase;

public class TestMemoryConsistencyJunit extends TestCase {

    volatile boolean sayHello= false;

    public void testMemoryInconsistent() throws InterruptedException {

        Thread thread = new Thread(() -> {
            while (!sayHello) {
            }

            System.out.println("Hello World!");

            while (sayHello) {
            }

            System.out.println("Good Bye!");
        });

        thread.start();

        Thread.sleep(1000);
        System.out.println("Say Hello..");
        sayHello = true;

        Thread.sleep(1000);
        System.out.println("Say Bye..");
        sayHello = false;
    }
}

