import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SubmitRunnable {
    public static void main(String arg[]) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();

        Future future = executorService.submit(newRunnable(" Task")); //not blocked

        System.out.println(future.isDone());
        try {
            future.get(); //blocked if the task not finished yet
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        } catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        System.out.println(future.isDone());

//        executorService.shutdown();
    }

    private static Runnable newRunnable(String msg) {
        return new Runnable() {
            @Override
            public void run() {
                String report = Thread.currentThread().getName() + " :" + msg;
                System.out.println(report);
            }
        };
    }
}

